/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.persistence;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonWriter;
import java.util.Map;
import java.util.Optional;
import org.mule.metadata.api.annotation.AccessibilityAnnotation;
import org.mule.metadata.api.annotation.DefaultValueAnnotation;
import org.mule.metadata.api.annotation.EnumAnnotation;
import org.mule.metadata.api.annotation.ExampleAnnotation;
import org.mule.metadata.api.annotation.LabelAnnotation;
import org.mule.metadata.api.annotation.RegexPatternAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.persistence.TypeAnnotationNameClassMapping;
import org.mule.metadata.persistence.type.adapter.EnumTypeAnnotationTypeAdapter;
import org.mule.metadata.persistence.type.adapter.OnlyOneFieldTypeAdapterFactory;
import org.mule.metadata.persistence.type.adapter.OptionalTypeAdapterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TypeAnnotationSerializer<T extends TypeAnnotation> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TypeAnnotationSerializer.class);
    private static final TypeAnnotationNameClassMapping annotationsNameClassMapping = new TypeAnnotationNameClassMapping();
    private static final String ERROR_DESERIALIZING_TYPE_ANNOTATION = "Error deserializing TypeAnnotation '%s'.";
    private final Gson gson = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new OptionalTypeAdapterFactory()).registerTypeAdapter(EnumAnnotation.class, (Object)new EnumTypeAnnotationTypeAdapter()).registerTypeAdapterFactory((TypeAdapterFactory)new OnlyOneFieldTypeAdapterFactory(AccessibilityAnnotation.class, LabelAnnotation.class, DefaultValueAnnotation.class, TypeIdAnnotation.class, RegexPatternAnnotation.class, ExampleAnnotation.class, DefaultValueAnnotation.class, RegexPatternAnnotation.class)).create();

    public Optional<T> deserialize(String typeAnnotationName, String json) {
        Optional<Object> optionalSerialization = Optional.empty();
        try {
            Optional<Class<TypeAnnotation>> annotationClass = this.getAnnotationClass(typeAnnotationName);
            if (annotationClass.isPresent()) {
                optionalSerialization = Optional.of((TypeAnnotation)this.gson.getAdapter(annotationClass.get()).fromJson(json));
            }
        }
        catch (Exception e) {
            LOGGER.error(String.format(ERROR_DESERIALIZING_TYPE_ANNOTATION, typeAnnotationName), (Throwable)e);
        }
        return optionalSerialization;
    }

    void serialize(JsonWriter jsonWriter, T typeAnnotation) {
        this.gson.toJson(typeAnnotation, new TypeToken<T>(){}.getType(), jsonWriter);
    }

    private Optional<Class<? extends TypeAnnotation>> getAnnotationClass(String annotationName) {
        Map<String, Class<? extends TypeAnnotation>> nameClassMapping = annotationsNameClassMapping.getNameClassMapping();
        Optional<Class<? extends TypeAnnotation>> optionalClass = Optional.empty();
        if (nameClassMapping.containsKey(annotationName)) {
            optionalClass = Optional.of(nameClassMapping.get(annotationName));
        } else {
            try {
                optionalClass = Optional.of(Class.forName(annotationName));
            }
            catch (Exception e) {
                LOGGER.error(String.format(ERROR_DESERIALIZING_TYPE_ANNOTATION, annotationName), (Throwable)e);
            }
        }
        return optionalClass;
    }
}

