/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.persistence.type.adapter;

import com.google.gson.Gson;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Optional;

final class OptionalTypeAdapter<T>
extends TypeAdapter<Optional<T>> {
    private final TypeToken<T> type;
    private final Gson gson;

    OptionalTypeAdapter(TypeToken<T> type, Gson gson) {
        this.type = type;
        this.gson = gson;
    }

    public void write(JsonWriter out, Optional<T> value) throws IOException {
        if (value != null && value.isPresent()) {
            this.gson.getAdapter(new TypeToken<T>(){}).write(out, value.get());
        } else {
            out.nullValue();
        }
    }

    public Optional<T> read(JsonReader in) throws IOException {
        Object t = this.gson.getAdapter(new TypeToken<T>(){}).fromJson(new JsonParser().parse(in).toString());
        return Optional.ofNullable(t);
    }
}

