/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.java.internal.handler;

import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.StringTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.metadata.java.api.handler.ClassHandler;
import org.mule.metadata.java.api.handler.TypeHandlerManager;
import org.mule.metadata.java.api.utils.ParsingContext;

import java.lang.reflect.Type;
import java.util.List;

public class EnumHandler implements ClassHandler {

  @Override
  public boolean handles(Class<?> clazz) {
    return clazz.isEnum();
  }

  @Override
  public TypeBuilder<?> handleClass(Class<?> clazz,
                                    List<Type> genericTypes, TypeHandlerManager typeHandlerManager,
                                    ParsingContext context, BaseTypeBuilder typeBuilder) {
    final StringTypeBuilder enumType = typeBuilder.stringType();
    enumType.id(clazz.getCanonicalName());
    final Object[] enumConstants = clazz.getEnumConstants();
    final String[] enumOf = new String[enumConstants.length];
    for (int i = 0; i < enumConstants.length; i++) {
      final Enum enumConstant = (Enum) enumConstants[i];
      enumOf[i] = enumConstant.name();
    }
    enumType.enumOf(enumOf)
        .with(new ClassInformationAnnotation(clazz));
    return enumType;
  }
}
