/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.java.internal.handler;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.metadata.java.api.handler.ClassHandler;
import org.mule.metadata.java.api.handler.TypeHandlerManager;
import org.mule.metadata.java.api.utils.ParsingContext;
import org.mule.metadata.java.api.utils.TypeResolver;

public class MapClassHandler
implements ClassHandler {
    @Override
    public boolean handles(Class<?> clazz) {
        return Map.class.isAssignableFrom(clazz);
    }

    @Override
    public TypeBuilder<?> handleClass(Class<?> clazz, List<Type> genericTypes, TypeHandlerManager typeHandlerManager, ParsingContext context, BaseTypeBuilder typeBuilder) {
        ObjectTypeBuilder objectTypeBuilder = typeBuilder.objectType();
        if (genericTypes.isEmpty()) {
            this.implementedInterfacesGenericsOrDefault(clazz, typeHandlerManager, context, objectTypeBuilder);
        } else {
            if (genericTypes.size() != 2) {
                throw new IllegalArgumentException(String.format("Exactly 2 generics were expected but %d were provided instead", genericTypes.size()));
            }
            this.openWith(typeHandlerManager, context, objectTypeBuilder, genericTypes.get(1));
        }
        objectTypeBuilder.with((TypeAnnotation)new ClassInformationAnnotation(clazz, genericTypes));
        return objectTypeBuilder;
    }

    private void implementedInterfacesGenericsOrDefault(Class<?> clazz, TypeHandlerManager typeHandlerManager, ParsingContext context, ObjectTypeBuilder objectTypeBuilder) {
        List<Type> superclassGenerics = this.getImplementedInterfaceGenerics(clazz);
        if (superclassGenerics.size() == 2) {
            this.openWith(typeHandlerManager, context, objectTypeBuilder, superclassGenerics.get(1));
        } else {
            objectTypeBuilder.open();
        }
    }

    private void openWith(TypeHandlerManager typeHandlerManager, ParsingContext context, ObjectTypeBuilder objectTypeBuilder, Type type) {
        Optional<TypeBuilder<?>> keyTypeBuilder = context.getTypeBuilder(type);
        if (keyTypeBuilder.isPresent()) {
            objectTypeBuilder.openWith(keyTypeBuilder.get());
        } else {
            typeHandlerManager.handle(type, context, objectTypeBuilder.openWith());
        }
    }

    private List<Type> getImplementedInterfaceGenerics(Class clazz) {
        return this.getImplementedInterfaceGenerics(clazz, new HashSet<Class>());
    }

    private List<Type> getImplementedInterfaceGenerics(Class clazz, Set<Class> analyzedClasses) {
        while (clazz != null && !Object.class.equals((Object)clazz)) {
            for (Type interfaceType : clazz.getGenericInterfaces()) {
                Class<?> interfaceClazz = TypeResolver.erase(interfaceType);
                if (analyzedClasses.contains(interfaceClazz)) continue;
                analyzedClasses.add(interfaceClazz);
                if (interfaceClazz.equals(Map.class)) {
                    ParameterizedType paramType = (ParameterizedType)interfaceType;
                    return Arrays.asList(paramType.getActualTypeArguments());
                }
                List<Type> interfaceGenerics = this.getImplementedInterfaceGenerics(interfaceClazz, analyzedClasses);
                if (interfaceGenerics.isEmpty()) continue;
                return interfaceGenerics;
            }
            clazz = clazz.getSuperclass();
        }
        return Collections.emptyList();
    }
}

