/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.java.internal.handler;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.ArrayTypeBuilder;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.metadata.java.api.handler.ClassHandler;
import org.mule.metadata.java.api.handler.TypeHandlerManager;
import org.mule.metadata.java.api.utils.ParsingContext;

public class ArrayClassHandler
implements ClassHandler {
    @Override
    public boolean handles(Class<?> clazz) {
        return clazz.isArray();
    }

    @Override
    public TypeBuilder<?> handleClass(Class<?> clazz, List<Type> genericTypes, TypeHandlerManager typeHandlerManager, ParsingContext context, BaseTypeBuilder typeBuilder) {
        Class<?> componentType = clazz.getComponentType();
        ArrayTypeBuilder arrayType = typeBuilder.arrayType().with((TypeAnnotation)new ClassInformationAnnotation(clazz));
        Optional<TypeBuilder<?>> mayBeType = context.getTypeBuilder(componentType);
        if (mayBeType.isPresent()) {
            arrayType.of(mayBeType.get());
        } else {
            typeHandlerManager.handle(componentType, context, arrayType.of());
        }
        return arrayType;
    }
}

