/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.builder;

import org.mule.metadata.api.annotation.DefaultValueAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.TypeParameterType;
import org.mule.metadata.api.model.impl.DefaultTypeParameterType;

public class TypeParameterTypeBuilder extends AbstractBuilder<TypeParameterType>
    implements TypeBuilder<TypeParameterType>, WithAnnotation<TypeParameterTypeBuilder> {

  private String name;

  protected TypeParameterTypeBuilder(String name, MetadataFormat format) {
    super(format);
    this.name = name;
  }

  public TypeParameterTypeBuilder with(TypeAnnotation extension) {
    this.addExtension(extension);
    return this;
  }

  public TypeParameterTypeBuilder id(String typeIdentifier) {
    return with(new TypeIdAnnotation(typeIdentifier));
  }

  public TypeParameterTypeBuilder defaultValue(String defaultValue) {
    return with(new DefaultValueAnnotation(defaultValue));
  }

  @Override
  public TypeParameterType build() {
    return new DefaultTypeParameterType(name, format, annotations);
  }
}
