/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.builder;

import org.mule.metadata.api.annotation.DefaultValueAnnotation;
import org.mule.metadata.api.annotation.RegexPatternAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.RegexType;
import org.mule.metadata.api.model.impl.DefaultRegexType;

public class RegexTypeBuilder extends AbstractBuilder<RegexType>
    implements TypeBuilder<RegexType>, WithAnnotation<RegexTypeBuilder> {

  protected RegexTypeBuilder(MetadataFormat format) {
    super(format);
  }

  public RegexTypeBuilder with(TypeAnnotation extension) {
    this.addExtension(extension);
    return this;
  }

  public RegexTypeBuilder id(String typeIdentifier) {
    return with(new TypeIdAnnotation(typeIdentifier));
  }

  public RegexTypeBuilder defaultValue(String defaultValue) {
    return with(new DefaultValueAnnotation(defaultValue));
  }

  public RegexTypeBuilder pattern(String pattern) {
    return with(new RegexPatternAnnotation(pattern));
  }

  @Override
  public RegexType build() {
    return new DefaultRegexType(format, annotations);
  }

}
