/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.api.builder;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.mule.metadata.api.annotation.DescriptionAnnotation;
import org.mule.metadata.api.annotation.LabelAnnotation;
import org.mule.metadata.api.annotation.LengthAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.annotation.UniquesItemsAnnotation;
import org.mule.metadata.api.builder.AbstractBuilder;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.builder.WithAnnotation;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.impl.DefaultArrayType;
import org.mule.metadata.internal.utils.LazyValue;

public class ArrayTypeBuilder
extends AbstractBuilder<ArrayType>
implements TypeBuilder<ArrayType>,
WithAnnotation<ArrayTypeBuilder> {
    private Optional<TypeBuilder<?>> arrayType;
    private Optional<MetadataType> typeValue;
    private LazyValue<ArrayType> result = new LazyValue();

    protected ArrayTypeBuilder(MetadataFormat format) {
        super(format);
        this.arrayType = Optional.empty();
        this.typeValue = Optional.empty();
    }

    public BaseTypeBuilder of() {
        BaseTypeBuilder typeBuilder = new BaseTypeBuilder(this.format);
        this.arrayType = Optional.of(typeBuilder);
        return typeBuilder;
    }

    public ArrayTypeBuilder id(String typeIdentifier) {
        return this.with(new TypeIdAnnotation(typeIdentifier));
    }

    public ArrayTypeBuilder of(TypeBuilder<?> builder) {
        this.arrayType = Optional.ofNullable(builder);
        return this;
    }

    public ArrayTypeBuilder of(MetadataType typeValue) {
        this.typeValue = Optional.ofNullable(typeValue);
        return this;
    }

    @Override
    public ArrayTypeBuilder with(TypeAnnotation extension) {
        this.addExtension(extension);
        return this;
    }

    public ArrayTypeBuilder boundary(Number minLength, Number maxLength) {
        return this.with(new LengthAnnotation(minLength, maxLength));
    }

    public ArrayTypeBuilder description(String lang, String content) {
        return this.with(new DescriptionAnnotation(content, lang));
    }

    public ArrayTypeBuilder description(String content) {
        return this.with(new DescriptionAnnotation(content));
    }

    public ArrayTypeBuilder uniques() {
        return this.with(new UniquesItemsAnnotation());
    }

    public ArrayTypeBuilder label(String label) {
        return this.with(new LabelAnnotation(label));
    }

    @Override
    public ArrayType build() {
        return this.typeValue.isPresent() ? new DefaultArrayType(() -> this.typeValue.get(), this.format, this.annotations) : this.buildArrayType(this.arrayType.orElseThrow(() -> new RuntimeException("Array type was not specified.")));
    }

    private ArrayType buildArrayType(TypeBuilder<?> arrayBuilder) {
        ArrayType type;
        AtomicReference<ArrayType> metadataTypeHolder = new AtomicReference<ArrayType>();
        if (this.isRecursiveType(arrayBuilder) || this.result.isDefined()) {
            type = this.result.get(() -> new DefaultArrayType(metadataTypeHolder::get, this.format, this.annotations));
            metadataTypeHolder.set(type);
        } else {
            metadataTypeHolder.set((ArrayType)arrayBuilder.build());
            type = this.result.get(() -> new DefaultArrayType(metadataTypeHolder::get, this.format, this.annotations));
        }
        return type;
    }

    private boolean isRecursiveType(TypeBuilder<?> typeBuilder) {
        return typeBuilder.equals(this);
    }
}

