/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.api.model.impl;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.ArrayUtils;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.AttributeKeyType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.impl.BaseMetadataType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.internal.utils.EfficientReflectionEquals;
import org.mule.metadata.internal.utils.EfficientReflectionHashCode;

public class DefaultAttributeKeyType
extends BaseMetadataType
implements AttributeKeyType {
    private final Optional<QName> name;
    private final Optional<Pattern> pattern;
    private transient boolean hashCalculated;
    private transient int hash;
    private static final Field[] REFLECTION_FIELDS;

    public DefaultAttributeKeyType(Optional<QName> name, Optional<Pattern> pattern, MetadataFormat metadataFormat, Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
        super(metadataFormat, extensions);
        this.name = name;
        this.pattern = pattern;
    }

    @Override
    public QName getName() {
        return this.name.get();
    }

    @Override
    public Pattern getPattern() {
        return this.pattern.get();
    }

    @Override
    public boolean isName() {
        return this.name.isPresent();
    }

    @Override
    public boolean isPattern() {
        return this.pattern.isPresent();
    }

    @Override
    public void accept(MetadataTypeVisitor visitor) {
        visitor.visitAttributeKey(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultAttributeKeyType)) {
            return false;
        }
        return EfficientReflectionEquals.reflectionEquals(this, (DefaultAttributeKeyType)o) && this.equalPattern(this.pattern, ((DefaultAttributeKeyType)o).pattern);
    }

    @Override
    public int hashCode() {
        if (!this.hashCalculated) {
            this.hash = Objects.hash(EfficientReflectionHashCode.reflectionHashCode(this), this.pattern.map(x -> x.toString().hashCode()).orElse(null));
            this.hashCalculated = true;
        }
        return this.hash;
    }

    boolean equalPattern(Optional<Pattern> thisPattern, Optional<Pattern> thatPattern) {
        if (thisPattern.isPresent() != thatPattern.isPresent()) {
            return false;
        }
        if (!thisPattern.isPresent() || !thatPattern.isPresent()) {
            return true;
        }
        return thisPattern.get().toString().equals(thatPattern.get().toString());
    }

    @Override
    public Field[] getReflectionComparableFields() {
        return REFLECTION_FIELDS;
    }

    static {
        try {
            REFLECTION_FIELDS = (Field[])ArrayUtils.addAll((Object[])BASE_REFLECTION_FIELDS, (Object[])new Field[]{DefaultAttributeKeyType.class.getDeclaredField("name")});
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Could not resolve field", e);
        }
    }
}

