/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.builder;

import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.model.IntersectionType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.impl.DefaultIntersectionType;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class IntersectionTypeBuilder extends AbstractBuilder<IntersectionType>
    implements TypeBuilder<IntersectionType>, WithAnnotation<IntersectionTypeBuilder> {

  private List<TypeBuilder<?>> types = new LinkedList<>();

  protected IntersectionTypeBuilder(MetadataFormat format) {
    super(format);
  }

  public BaseTypeBuilder of() {
    final BaseTypeBuilder builder = new BaseTypeBuilder(format);
    this.types.add(builder);
    return builder;
  }

  public IntersectionTypeBuilder of(TypeBuilder<?> of) {
    this.types.add(of);
    return this;
  }

  public IntersectionTypeBuilder id(String typeIdentifier) {
    return with(new TypeIdAnnotation(typeIdentifier));
  }

  public IntersectionTypeBuilder with(TypeAnnotation extension) {
    this.addExtension(extension);
    return this;
  }


  @Override
  public IntersectionType build() {
    if (types.isEmpty()) {
      throw new RuntimeException("Tuple needs at least one type");
    }
    final List<MetadataType> types = this.types.stream()
        .map((builder) -> builder.build())
        .collect(Collectors.toList());

    return new DefaultIntersectionType(types, format, annotations);
  }
}
