/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.message.api.el;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.api.el.ModuleIdentifier;

public class ModuleDefinition {
    private ModuleIdentifier name;
    private Map<String, MetadataType> declaredElements;
    private List<MetadataType> declaredTypes;

    public ModuleDefinition(ModuleIdentifier name, Map<String, MetadataType> declaredElements) {
        this.name = name;
        this.declaredElements = declaredElements;
        this.declaredTypes = new ArrayList<MetadataType>();
    }

    public ModuleDefinition(ModuleIdentifier name, Map<String, MetadataType> declaredElements, List<MetadataType> declaredTypes) {
        this.name = name;
        this.declaredElements = declaredElements;
        this.declaredTypes = declaredTypes;
    }

    public ModuleIdentifier getName() {
        return this.name;
    }

    public Collection<String> identifiers() {
        return this.declaredElements.keySet();
    }

    public List<MetadataType> declaredTypes() {
        return this.declaredTypes;
    }

    public Optional<MetadataType> lookup(String identifier) {
        return Optional.ofNullable(this.declaredElements.get(identifier));
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public static class Builder {
        private String name;
        private Map<String, MetadataType> declaredElements;
        private List<MetadataType> declaredTypes;

        public Builder(String name) {
            this.name = name;
            this.declaredElements = new HashMap<String, MetadataType>();
            this.declaredTypes = new ArrayList<MetadataType>();
        }

        public Builder addElement(String name, MetadataType type) {
            this.declaredElements.put(name, type);
            return this;
        }

        public Builder addType(MetadataType type) {
            this.declaredTypes.add(type);
            return this;
        }

        public ModuleDefinition build() {
            return new ModuleDefinition(ModuleIdentifier.fromString(this.name), this.declaredElements, this.declaredTypes);
        }
    }
}

