/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.api.domain.entity;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.apache.commons.io.IOUtils;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.entity.HttpEntity;

@NoExtend
public class InputStreamHttpEntity
implements HttpEntity {
    private OptionalLong contentLength;
    private InputStream inputStream;
    private CompletableFuture<MultiMap<String, String>> futureTrailers;

    public InputStreamHttpEntity(InputStream inputStream) {
        Objects.requireNonNull(inputStream, "HTTP entity stream cannot be null.");
        this.inputStream = inputStream;
        this.contentLength = OptionalLong.empty();
        this.futureTrailers = CompletableFuture.completedFuture(MultiMap.emptyMultiMap());
    }

    @Deprecated
    public InputStreamHttpEntity(InputStream inputStream, Long contentLength) {
        this(inputStream);
        this.contentLength = contentLength == null ? OptionalLong.empty() : OptionalLong.of(contentLength);
    }

    public InputStreamHttpEntity(InputStream inputStream, long contentLength) {
        this(inputStream);
        this.contentLength = OptionalLong.of(contentLength);
    }

    public InputStreamHttpEntity(InputStream inputStream, OptionalLong contentLength) {
        this(inputStream);
        this.contentLength = contentLength;
    }

    public InputStreamHttpEntity(InputStream stream, long contentLengthAsLong, CompletableFuture<MultiMap<String, String>> futureTrailers) {
        this(stream, contentLengthAsLong);
        this.futureTrailers = futureTrailers;
    }

    public InputStreamHttpEntity(InputStream stream, CompletableFuture<MultiMap<String, String>> futureTrailers) {
        this(stream);
        this.futureTrailers = futureTrailers;
    }

    @Override
    public boolean isStreaming() {
        return true;
    }

    @Override
    public InputStream getContent() {
        return this.inputStream;
    }

    @Override
    public byte[] getBytes() throws IOException {
        return IOUtils.toByteArray((InputStream)this.inputStream);
    }

    @Override
    public Optional<Long> getLength() {
        return this.contentLength.isPresent() ? Optional.of(this.contentLength.getAsLong()) : Optional.empty();
    }

    @Override
    public OptionalLong getBytesLength() {
        return this.contentLength;
    }

    @Override
    public void onComplete(BiConsumer<? super MultiMap<String, String>, ? super Throwable> completionCallback) {
        this.futureTrailers.whenComplete(completionCallback);
    }
}

