/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.util;

import java.lang.reflect.AccessibleObject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ConnectableComponentModel;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.SubTypesModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.display.ClassValueModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.nested.NestedChainModel;
import org.mule.runtime.api.meta.model.nested.NestedRouteModel;
import org.mule.runtime.api.meta.model.operation.HasOperationModels;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.HasSourceModels;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.display.ClassValue;
import org.mule.runtime.extension.api.property.ClassLoaderModelProperty;
import org.mule.runtime.extension.api.property.InfrastructureParameterModelProperty;
import org.mule.runtime.extension.api.property.NoImplicitModelProperty;
import org.mule.runtime.extension.privileged.util.ComponentDeclarationUtils;
import org.mule.sdk.api.annotation.param.Optional;

public class ExtensionModelUtils {
    private static final String EXPRESSION_PREFIX = "#[";
    private static final String EXPRESSION_POSTFIX = "]";

    private ExtensionModelUtils() {
    }

    public static java.util.Optional<String> getDefaultValue(ParameterModel model) {
        Object defaultValue = model.getDefaultValue();
        return defaultValue == null ? java.util.Optional.empty() : java.util.Optional.of(String.valueOf(defaultValue));
    }

    public static boolean hasExpressionDefaultValue(ParameterModel model) {
        Object defaultValue = model.getDefaultValue();
        if (defaultValue instanceof String) {
            String trim = ((String)defaultValue).trim();
            return trim.startsWith(EXPRESSION_PREFIX) && trim.endsWith(EXPRESSION_POSTFIX);
        }
        return false;
    }

    public static java.util.Optional<String> getDefaultValue(final String name, MetadataType model) {
        final Reference value = new Reference();
        model.accept(new MetadataTypeVisitor(){

            protected void defaultVisit(MetadataType metadataType) {
                MetadataTypeUtils.getDefaultValue((MetadataType)metadataType).ifPresent(arg_0 -> ((Reference)value).set(arg_0));
            }

            public void visitObject(ObjectType objectType) {
                objectType.getFields().stream().filter(f -> f.getKey().getName().getLocalPart().equals(name)).findFirst().ifPresent(fieldType -> MetadataTypeUtils.getDefaultValue((MetadataType)fieldType).ifPresent(arg_0 -> ((Reference)value).set(arg_0)));
            }

            public void visitUnion(UnionType unionType) {
                unionType.getTypes().stream().map(type -> ExtensionModelUtils.getDefaultValue(name, type)).filter(java.util.Optional::isPresent).findFirst().ifPresent(defaultValue -> value.set((Object)((String)defaultValue.get())));
            }
        });
        return java.util.Optional.ofNullable((String)value.get());
    }

    public static boolean acceptsExpressions(ExpressionSupport support) {
        return support == ExpressionSupport.SUPPORTED || support == ExpressionSupport.REQUIRED;
    }

    public static List<ComponentModel> getConnectedComponents(ExtensionModel extensionModel) {
        final LinkedList<ComponentModel> connectedModels = new LinkedList<ComponentModel>();
        new IdempotentExtensionWalker(){

            public void onOperation(OperationModel model) {
                this.collect((ConnectableComponentModel)model);
            }

            public void onSource(SourceModel model) {
                this.collect((ConnectableComponentModel)model);
            }

            private void collect(ConnectableComponentModel model) {
                if (model.requiresConnection()) {
                    connectedModels.add(model);
                }
            }
        }.walk(extensionModel);
        return connectedModels;
    }

    public static List<ComponentModel> getConnectedComponents(ExtensionModel extensionModel, final ConfigurationModel configurationModel) {
        final LinkedList<ComponentModel> connectedModels = new LinkedList<ComponentModel>();
        new ExtensionWalker(){

            public void onOperation(HasOperationModels owner, OperationModel model) {
                if (owner == configurationModel) {
                    this.collect(owner, (ConnectableComponentModel)model);
                }
            }

            public void onSource(HasSourceModels owner, SourceModel model) {
                this.collect(owner, (ConnectableComponentModel)model);
            }

            private void collect(Object owner, ConnectableComponentModel model) {
                if (owner == configurationModel && model.requiresConnection()) {
                    connectedModels.add(model);
                }
            }
        }.walk(extensionModel);
        return connectedModels;
    }

    public static boolean supportsConnectivity(ExtensionModel extensionModel, ConfigurationModel configurationModel) {
        return !extensionModel.getConnectionProviders().isEmpty() || !configurationModel.getConnectionProviders().isEmpty();
    }

    public static boolean requiresConfig(ExtensionModel extensionModel, final NamedObject component) {
        if (!(component instanceof ConnectableComponentModel)) {
            return false;
        }
        if (ComponentDeclarationUtils.isConnectionProvisioningRequired((ConnectableComponentModel)component)) {
            return true;
        }
        final Reference result = new Reference((Object)false);
        new ExtensionWalker(){

            public void onOperation(HasOperationModels owner, OperationModel model) {
                this.resolve((ComponentModel)model, owner);
            }

            public void onSource(HasSourceModels owner, SourceModel model) {
                this.resolve((ComponentModel)model, owner);
            }

            private void resolve(ComponentModel model, Object owner) {
                if (!(owner instanceof ExtensionModel) && model == component) {
                    result.set((Object)true);
                    this.stop();
                }
            }
        }.walk(extensionModel);
        return (Boolean)result.get();
    }

    public static Set<ConfigurationModel> getConfigurationForComponent(final ExtensionModel extensionModel, final ComponentModel component) {
        final HashSet<ConfigurationModel> result = new HashSet<ConfigurationModel>();
        new ExtensionWalker(){

            public void onOperation(HasOperationModels owner, OperationModel model) {
                this.resolve((ComponentModel)model, owner);
            }

            public void onSource(HasSourceModels owner, SourceModel model) {
                this.resolve((ComponentModel)model, owner);
            }

            private void resolve(ComponentModel model, Object owner) {
                if (model == component && owner != extensionModel) {
                    result.add((ConfigurationModel)owner);
                }
            }
        }.walk(extensionModel);
        if (component instanceof ConnectableComponentModel && ((ConnectableComponentModel)component).requiresConnection()) {
            extensionModel.getConfigurationModel("config").ifPresent(result::add);
        }
        return result;
    }

    public static boolean isContent(ParameterModel parameterModel) {
        return ExtensionModelUtils.isContent(parameterModel.getRole());
    }

    public static boolean isText(ParameterModel parameter) {
        return parameter.getLayoutModel().map(LayoutModel::isText).orElse(false);
    }

    public static boolean isContent(ParameterRole purpose) {
        Preconditions.checkArgument((purpose != null ? 1 : 0) != 0, (String)"cannot evaluate null purpose");
        return purpose != ParameterRole.BEHAVIOUR;
    }

    public static ParameterRole roleOf(java.util.Optional<Content> content) {
        return content.map(c -> c.primary() ? ParameterRole.PRIMARY_CONTENT : ParameterRole.CONTENT).orElse(ParameterRole.BEHAVIOUR);
    }

    public static Map<ObjectType, Set<ObjectType>> toSubTypesMap(Collection<SubTypesModel> subTypes) {
        return subTypes.stream().collect(Collectors.toMap(SubTypesModel::getBaseType, SubTypesModel::getSubTypes));
    }

    public static boolean isInfrastructure(ParameterModel parameter) {
        return parameter.getModelProperty(InfrastructureParameterModelProperty.class).isPresent();
    }

    public static <T extends ParameterizedModel> T getFirstImplicit(List<T> models) {
        return (T)((ParameterizedModel)models.stream().filter(ExtensionModelUtils::canBeUsedImplicitly).findFirst().orElse(null));
    }

    public static boolean canBeUsedImplicitly(ParameterizedModel parameterizedModel) {
        if (parameterizedModel instanceof EnrichableModel && ((EnrichableModel)parameterizedModel).getModelProperty(NoImplicitModelProperty.class).isPresent()) {
            return false;
        }
        return parameterizedModel.getAllParameterModels().stream().filter(p -> !p.isComponentId()).noneMatch(p -> p.isRequired());
    }

    public static boolean componentHasAnImplicitConfiguration(ExtensionModel extension, ComponentModel component) {
        List configs = extension.getConfigurationModels();
        if (configs.isEmpty()) {
            return true;
        }
        List implicitConfigs = configs.stream().filter(config -> config.getOperationModels().contains(component) || config.getSourceModels().contains(component)).filter(config -> ExtensionModelUtils.canBeUsedImplicitly((ParameterizedModel)config)).collect(Collectors.toList());
        return implicitConfigs.stream().anyMatch(config -> {
            List providers = config.getConnectionProviders();
            return providers.isEmpty() || providers.stream().anyMatch(cp -> ExtensionModelUtils.canBeUsedImplicitly((ParameterizedModel)cp));
        });
    }

    public static String getDefaultValue(org.mule.runtime.extension.api.annotation.param.Optional optional) {
        if (optional == null) {
            return null;
        }
        String defaultValue = optional.defaultValue();
        return "THIS IS A SPECIAL NULL VALUE - DO NOT USE".equals(defaultValue) ? null : defaultValue;
    }

    public static String getDefaultValue(Optional optional) {
        if (optional == null) {
            return null;
        }
        String defaultValue = optional.defaultValue();
        return "THIS IS A SPECIAL NULL VALUE - DO NOT USE".equals(defaultValue) ? null : defaultValue;
    }

    public static Object getDefaultValue(AccessibleObject object) {
        Optional optional = object.getAnnotation(Optional.class);
        if (optional != null) {
            return ExtensionModelUtils.getDefaultValue(optional);
        }
        return ExtensionModelUtils.getDefaultValue(object.getAnnotation(org.mule.runtime.extension.api.annotation.param.Optional.class));
    }

    public static boolean isRequired(ParameterGroupModel group) {
        return group.getParameterModels().stream().anyMatch(ParameterModel::isRequired);
    }

    public static ClassValueModel toClassValueModel(ClassValue annotation) {
        String[] parents = annotation.extendsOrImplements();
        if (parents != null) {
            return new ClassValueModel(Stream.of(parents).filter(p -> !StringUtils.isBlank((CharSequence)p)).collect(Collectors.toList()));
        }
        return new ClassValueModel(Collections.emptyList());
    }

    public static java.util.Optional<ClassLoader> getExtensionClassLoader(ExtensionModel extensionModel) {
        return extensionModel.getModelProperty(ClassLoaderModelProperty.class).map(classLoaderModelProperty -> classLoaderModelProperty.getClassLoader());
    }

    public static Stream<Pair<ParameterGroupModel, ParameterModel>> getGroupAndParametersPairs(ParameterizedModel model) {
        return model.getParameterGroupModels().stream().flatMap(g -> g.getParameterModels().stream().map(p -> new Pair(g, p)));
    }

    public static boolean isScope(ComponentModel model) {
        return model.getNestedComponents().stream().anyMatch(nested -> nested instanceof NestedChainModel);
    }

    public static boolean isRouter(ConstructModel model) {
        return model.getNestedComponents().stream().anyMatch(nested -> nested instanceof NestedRouteModel);
    }

    public static boolean isRouter(ComponentModel model) {
        return model.getNestedComponents().stream().anyMatch(nested -> nested instanceof NestedRouteModel);
    }

    public static boolean supportsMultiple(NestedRouteModel routeModel) {
        return routeModel.getMaxOccurs().map(i -> i > 1).orElse(true);
    }
}

