/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.util;

import org.mule.runtime.api.meta.model.ConnectableComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.declaration.fluent.BaseDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExecutableComponentDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.extension.internal.ExtensionDevelopmentFramework;
import org.mule.runtime.extension.internal.property.NoReconnectionStrategyModelProperty;

public class ExtensionConnectivityUtils {
    private ExtensionConnectivityUtils() {
    }

    public static boolean isConnectionProvisioningRequired(ExtensionModel extensionModel, ConnectableComponentModel componentModel) {
        return componentModel.requiresConnection() && !ExtensionDevelopmentFramework.isExtensionDevelopmentFramework(extensionModel, ExtensionDevelopmentFramework.MULE_DSL);
    }

    public static boolean isReconnectionStrategySupported(ConnectableComponentModel componentModel) {
        return !componentModel.getModelProperty(NoReconnectionStrategyModelProperty.class).isPresent();
    }

    public static boolean isReconnectionStrategySupported(ExtensionDeclaration declaration) {
        return ExtensionConnectivityUtils.isReconnectionStrategySupported(declaration);
    }

    public static boolean isReconnectionStrategySupported(ExecutableComponentDeclaration<?> declaration) {
        return ExtensionConnectivityUtils.isReconnectionStrategySupported(declaration);
    }

    private static boolean isReconnectionStrategySupported(BaseDeclaration<?> declaration) {
        return !declaration.getModelProperty(NoReconnectionStrategyModelProperty.class).isPresent();
    }
}

