/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.property;

import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.extension.api.annotation.source.BackPressure;
import org.mule.runtime.extension.api.runtime.source.BackPressureMode;

public class BackPressureStrategyModelProperty
implements ModelProperty {
    private BackPressureMode defaultMode;
    private Set<BackPressureMode> supportedModes;

    public static BackPressureStrategyModelProperty getDefault() {
        BackPressureStrategyModelProperty property = new BackPressureStrategyModelProperty();
        property.defaultMode = BackPressureMode.WAIT;
        property.supportedModes = EnumSet.of(BackPressureMode.WAIT);
        return property;
    }

    public static BackPressureStrategyModelProperty of(BackPressure annotation) {
        BackPressureStrategyModelProperty settings = new BackPressureStrategyModelProperty();
        settings.defaultMode = annotation.defaultMode();
        settings.supportedModes = new LinkedHashSet<BackPressureMode>();
        for (BackPressureMode supported : annotation.supportedModes()) {
            settings.supportedModes.add(supported);
        }
        return settings;
    }

    private BackPressureStrategyModelProperty() {
    }

    public BackPressureStrategyModelProperty(BackPressureMode defaultMode, Set<BackPressureMode> supportedModes) {
        this.defaultMode = defaultMode;
        this.supportedModes = supportedModes;
    }

    public BackPressureMode getDefaultMode() {
        return this.defaultMode;
    }

    public Set<BackPressureMode> getSupportedModes() {
        return this.supportedModes;
    }

    public String getName() {
        return "backPressure";
    }

    public boolean isPublic() {
        return false;
    }
}

