/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.enricher;

import java.util.Set;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConstructDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExecutableComponentDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.extension.api.declaration.fluent.util.IdempotentDeclarationWalker;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.DeclarationEnricherPhase;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.NameUtils;

public final class ExtensionTypesDeclarationEnricher
implements DeclarationEnricher {
    @Override
    public DeclarationEnricherPhase getExecutionPhase() {
        return DeclarationEnricherPhase.STRUCTURE;
    }

    @Override
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        ExtensionDeclarer declarer = extensionLoadingContext.getExtensionDeclarer();
        this.declareSubTypes(declarer);
        this.declareDefaultTypes(declarer);
        ((ExtensionDeclaration)declarer.getDeclaration()).getNotificationModels().forEach(notification -> this.registerType(declarer, notification.getType()));
    }

    private void declareSubTypes(ExtensionDeclarer declarer) {
        ((ExtensionDeclaration)declarer.getDeclaration()).getSubTypes().forEach(type -> {
            this.registerType(declarer, (MetadataType)type.getBaseType());
            this.registerTypes(declarer, type.getSubTypes());
        });
    }

    private void declareDefaultTypes(final ExtensionDeclarer declarer) {
        new IdempotentDeclarationWalker(){

            @Override
            public void onSource(SourceDeclaration declaration) {
                this.registerParametersType((ParameterizedDeclaration<? extends ParameterizedDeclaration>)declaration);
                ExtensionTypesDeclarationEnricher.this.registerType(declarer, (ExecutableComponentDeclaration)declaration);
            }

            @Override
            public void onOperation(OperationDeclaration declaration) {
                this.registerParametersType((ParameterizedDeclaration<? extends ParameterizedDeclaration>)declaration);
                ExtensionTypesDeclarationEnricher.this.registerType(declarer, (ExecutableComponentDeclaration)declaration);
            }

            @Override
            protected void onConnectionProvider(ConnectionProviderDeclaration declaration) {
                this.registerParametersType((ParameterizedDeclaration<? extends ParameterizedDeclaration>)declaration);
            }

            protected void onConfiguration(ConfigurationDeclaration declaration) {
                this.registerParametersType((ParameterizedDeclaration<? extends ParameterizedDeclaration>)declaration);
            }

            @Override
            protected void onConstruct(ConstructDeclaration declaration) {
                this.registerParametersType((ParameterizedDeclaration<? extends ParameterizedDeclaration>)declaration);
            }

            private void registerParametersType(ParameterizedDeclaration<? extends ParameterizedDeclaration> parameterizedDeclaration) {
                for (ParameterDeclaration parameterDeclaration : parameterizedDeclaration.getAllParameters()) {
                    ExtensionTypesDeclarationEnricher.this.registerType(declarer, parameterDeclaration.getType());
                }
            }
        }.walk((ExtensionDeclaration)declarer.getDeclaration());
    }

    private void registerTypes(ExtensionDeclarer declarer, Set<ObjectType> types) {
        types.forEach(type -> this.registerType(declarer, (MetadataType)type));
    }

    private void registerType(ExtensionDeclarer declarer, ExecutableComponentDeclaration<?> declaration) {
        if (declaration.getOutput() == null) {
            throw new IllegalModelDefinitionException(String.format("%s '%s' doesn't specify an output type", NameUtils.getComponentDeclarationTypeName(declaration), declaration.getName()));
        }
        if (declaration.getOutputAttributes() == null) {
            throw new IllegalModelDefinitionException(String.format("%s '%s' doesn't specify output attributes types", NameUtils.getComponentDeclarationTypeName(declaration), declaration.getName()));
        }
        this.registerType(declarer, declaration.getOutput().getType());
        this.registerType(declarer, declaration.getOutputAttributes().getType());
    }

    private void registerType(ExtensionDeclarer declarer, MetadataType type) {
        ExtensionMetadataTypeUtils.registerType(declarer, type);
    }
}

