/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.util;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.scheduler.SchedulingStrategy;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.tx.TransactionType;
import org.mule.runtime.api.util.collection.Collectors;
import org.mule.runtime.extension.api.error.ErrorMapping;
import org.mule.runtime.extension.api.property.QNameModelProperty;
import org.mule.runtime.extension.api.tx.OperationTransactionalAction;
import org.mule.runtime.extension.api.tx.SourceTransactionalAction;
import org.mule.runtime.internal.dsl.DslConstants;

public final class InfrastructureTypeMapping {
    public static final String TLS_NAMESPACE_URI = "http://www.mulesoft.org/schema/mule/tls";
    private static final Map<Class<?>, InfrastructureType> MAPPING = ImmutableMap.builder().put(TlsContextFactory.class, (Object)new InfrastructureType("tlsContext", 8)).put(SourceTransactionalAction.class, (Object)new InfrastructureType("transactionalAction", 6)).put(OperationTransactionalAction.class, (Object)new InfrastructureType("transactionalAction", 7)).put(TransactionType.class, (Object)new InfrastructureType("transactionType", 9)).put(SchedulingStrategy.class, (Object)new InfrastructureType("schedulingStrategy", 10)).put(ErrorMapping.class, (Object)new InfrastructureType("errorMappings", 11)).build();
    private static final Map<String, QNameModelProperty> QNAMES = ImmutableMap.builder().put((Object)"schedulingStrategy", (Object)new QNameModelProperty(new QName(DslConstants.CORE_NAMESPACE, "scheduling-strategy", "mule"))).put((Object)"errorMappings", (Object)new QNameModelProperty(new QName(DslConstants.CORE_NAMESPACE, "error-mapping", "mule"))).put((Object)"tlsContext", (Object)new QNameModelProperty(new QName("http://www.mulesoft.org/schema/mule/tls", "context", "tls"))).put((Object)"custom-ocsp-responder", (Object)new QNameModelProperty(new QName("http://www.mulesoft.org/schema/mule/tls", "custom-ocsp-responder", "tls"))).put((Object)"standard-revocation-check", (Object)new QNameModelProperty(new QName("http://www.mulesoft.org/schema/mule/tls", "standard-revocation-check", "tls"))).put((Object)"crl-file", (Object)new QNameModelProperty(new QName("http://www.mulesoft.org/schema/mule/tls", "crl-file", "tls"))).build();
    private static final Map<ComponentIdentifier, Class<?>> IDENTIFIER_TYPE_MAPPING = (Map)MAPPING.entrySet().stream().filter(entry -> InfrastructureTypeMapping.getQName(((InfrastructureType)entry.getValue()).getName()).isPresent()).collect(Collectors.toImmutableMap(entry -> {
        QName qName = InfrastructureTypeMapping.getQName(((InfrastructureType)entry.getValue()).getName()).get().getValue();
        return ComponentIdentifier.builder().namespaceUri(qName.getNamespaceURI()).namespace(qName.getPrefix()).name(qName.getLocalPart()).build();
    }, Map.Entry::getKey));
    private static final Map<String, ParameterDslConfiguration> DSL_CONFIGURATIONS = ImmutableMap.builder().put((Object)"schedulingStrategy", (Object)ParameterDslConfiguration.builder().allowsInlineDefinition(true).allowTopLevelDefinition(false).allowsReferences(false).build()).put((Object)"errorMappings", (Object)ParameterDslConfiguration.builder().allowsInlineDefinition(true).allowTopLevelDefinition(false).allowsReferences(false).build()).put((Object)"tlsContext", (Object)ParameterDslConfiguration.builder().allowsInlineDefinition(true).allowTopLevelDefinition(true).allowsReferences(true).build()).put((Object)"transactionalAction", (Object)ParameterDslConfiguration.builder().allowsInlineDefinition(false).allowTopLevelDefinition(false).allowsReferences(false).build()).put((Object)"transactionType", (Object)ParameterDslConfiguration.builder().allowsInlineDefinition(false).allowTopLevelDefinition(false).allowsReferences(false).build()).build();
    private static Map<String, String> nameMap = (Map)MAPPING.entrySet().stream().collect(Collectors.toImmutableMap(e -> ((Class)e.getKey()).getName(), e -> ((InfrastructureType)e.getValue()).getName()));

    public static Map<Class<?>, InfrastructureType> getMap() {
        return MAPPING;
    }

    public static Map<String, String> getNameMap() {
        return nameMap;
    }

    public static Optional<QNameModelProperty> getQName(String name) {
        return Optional.ofNullable(QNAMES.get(name));
    }

    public static Optional<ParameterDslConfiguration> getDslConfiguration(String name) {
        return Optional.ofNullable(DSL_CONFIGURATIONS.get(name));
    }

    public static Optional<Class<?>> getTypeFor(ComponentIdentifier compId) {
        return Optional.ofNullable(IDENTIFIER_TYPE_MAPPING.get(compId));
    }

    private InfrastructureTypeMapping() {
    }

    public static class InfrastructureType {
        private final String name;
        private final int sequence;

        InfrastructureType(String name, int sequence) {
            this.name = name;
            this.sequence = sequence;
        }

        public String getName() {
            return this.name;
        }

        public int getSequence() {
            return this.sequence;
        }
    }
}

