/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.DescribedObject;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.connection.HasConnectionProviderModels;
import org.mule.runtime.api.meta.model.deprecated.DeprecableModel;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.operation.HasOperationModels;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.HasSourceModels;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.model.AbstractNamedImmutableModel;

public abstract class AbstractComplexModel
extends AbstractNamedImmutableModel
implements HasConnectionProviderModels,
HasSourceModels,
HasOperationModels,
DeprecableModel {
    private final List<OperationModel> operations;
    private final List<ConnectionProviderModel> connectionProviders;
    private final List<SourceModel> messageSources;
    private final DeprecationModel deprecationModel;

    public AbstractComplexModel(String name, String description, List<OperationModel> operationModels, List<ConnectionProviderModel> connectionProviders, List<SourceModel> sourceModels, DisplayModel displayModel, Set<ModelProperty> modelProperties) {
        super(name, description, displayModel, modelProperties);
        this.operations = this.copy(operationModels);
        this.connectionProviders = this.copy(connectionProviders);
        this.messageSources = this.copy(sourceModels);
        this.deprecationModel = null;
    }

    public AbstractComplexModel(String name, String description, List<OperationModel> operationModels, List<ConnectionProviderModel> connectionProviders, List<SourceModel> sourceModels, DisplayModel displayModel, Set<ModelProperty> modelProperties, DeprecationModel deprecationModel) {
        super(name, description, displayModel, modelProperties);
        this.operations = this.copy(operationModels);
        this.connectionProviders = this.copy(connectionProviders);
        this.messageSources = this.copy(sourceModels);
        this.deprecationModel = deprecationModel;
    }

    public List<OperationModel> getOperationModels() {
        return this.operations;
    }

    public List<SourceModel> getSourceModels() {
        return this.messageSources;
    }

    public Optional<SourceModel> getSourceModel(String name) {
        return this.findModel(this.messageSources, name);
    }

    public Optional<ConnectionProviderModel> getConnectionProviderModel(String name) {
        return this.findModel(this.connectionProviders, name);
    }

    public Optional<OperationModel> getOperationModel(String name) {
        return this.findModel(this.operations, name);
    }

    public List<ConnectionProviderModel> getConnectionProviders() {
        return this.connectionProviders;
    }

    protected <T extends NamedObject> Optional<T> findModel(Collection<T> values, String name) {
        return values.stream().filter(v -> v.getName().equals(name)).findFirst();
    }

    protected <T extends DescribedObject> List<T> toList(Collection<T> collection) {
        if (collection == null || collection.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<T>(collection));
    }

    protected <T extends NamedObject> List<T> unique(Collection<T> values, String identifier) {
        HashMap nameCounts = new HashMap();
        values.stream().map(NamedObject::getName).forEach(name -> nameCounts.put(name, nameCounts.getOrDefault(name, 0) + 1));
        List invalid = nameCounts.entrySet().stream().filter(entry -> (Integer)entry.getValue() > 1).map(Map.Entry::getKey).collect(Collectors.toList());
        if (!invalid.isEmpty()) {
            throw new IllegalModelDefinitionException(String.format("%s %s were defined multiple times", identifier, invalid));
        }
        return Collections.unmodifiableList(new ArrayList<T>(values));
    }

    public Optional<DeprecationModel> getDeprecationModel() {
        return Optional.ofNullable(this.deprecationModel);
    }

    public boolean isDeprecated() {
        return this.deprecationModel != null;
    }

    @Override
    public String toString() {
        return "AbstractComplexModel{operations=" + this.operations + ", connectionProviders=" + this.connectionProviders + ", messageSources=" + this.messageSources + ", deprecationModel=" + this.deprecationModel + "} " + super.toString();
    }
}

