/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.enricher;

import java.util.Optional;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.extension.api.loader.DeclarationEnricherPhase;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.IdempotentDeclarationEnricherWalkDelegate;
import org.mule.runtime.extension.api.loader.WalkingDeclarationEnricher;
import org.mule.runtime.extension.api.property.SourceClusterSupportModelProperty;
import org.mule.runtime.extension.internal.loader.util.InfrastructureParameterBuilder;
import org.mule.sdk.api.annotation.source.SourceClusterSupport;

public class ClusterSupportEnricher
implements WalkingDeclarationEnricher {
    @Override
    public DeclarationEnricherPhase getExecutionPhase() {
        return DeclarationEnricherPhase.STRUCTURE;
    }

    @Override
    public Optional<WalkingDeclarationEnricher.DeclarationEnricherWalkDelegate> getWalkDelegate(ExtensionLoadingContext extensionLoadingContext) {
        return Optional.of(new IdempotentDeclarationEnricherWalkDelegate(){

            @Override
            protected void onSource(SourceDeclaration declaration) {
                Optional<SourceClusterSupport> optionalSourceClusterSupport = declaration.getModelProperty(SourceClusterSupportModelProperty.class).map(SourceClusterSupportModelProperty::getSourceClusterSupport);
                if (optionalSourceClusterSupport.isPresent()) {
                    SourceClusterSupport sourceClusterSupport = optionalSourceClusterSupport.get();
                    switch (sourceClusterSupport) {
                        case DEFAULT_PRIMARY_NODE_ONLY: {
                            InfrastructureParameterBuilder.addPrimaryNodeParameter(declaration, true);
                            declaration.setRunsOnPrimaryNodeOnly(false);
                            break;
                        }
                        case DEFAULT_ALL_NODES: {
                            InfrastructureParameterBuilder.addPrimaryNodeParameter(declaration, false);
                            declaration.setRunsOnPrimaryNodeOnly(false);
                            break;
                        }
                        default: {
                            declaration.setRunsOnPrimaryNodeOnly(true);
                        }
                    }
                }
            }
        });
    }
}

