/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.declaration.type;

import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.BooleanTypeBuilder;
import org.mule.metadata.api.builder.NumberTypeBuilder;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.StringTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.java.api.utils.ParsingContext;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.extension.api.declaration.type.annotation.LayoutTypeAnnotation;

abstract class InfrastructureTypeBuilder {
    InfrastructureTypeBuilder() {
    }

    protected ObjectTypeBuilder objectType(BaseTypeBuilder typeBuilder, Class<?> type, ParsingContext context) {
        ObjectTypeBuilder objectType = typeBuilder.objectType().id(type.getName());
        context.addTypeBuilder(type, (TypeBuilder)objectType);
        return objectType;
    }

    protected ObjectFieldTypeBuilder addEnumField(ObjectTypeBuilder objectType, BaseTypeBuilder typeBuilder, String name, String description, String defaultValue, String ... values) {
        return this.addField(objectType, (TypeBuilder)this.getEnumType(typeBuilder, defaultValue, values), name, description);
    }

    protected StringTypeBuilder getEnumType(BaseTypeBuilder typeBuilder, String defaultValue, String ... values) {
        StringTypeBuilder enumType = typeBuilder.stringType().id(String.class.getName()).enumOf(values);
        if (defaultValue != null) {
            enumType.defaultValue(defaultValue);
        }
        return enumType;
    }

    protected ObjectFieldTypeBuilder addBooleanField(ObjectTypeBuilder objectType, BaseTypeBuilder typeBuilder, String name, String description, Boolean defaultValue) {
        BooleanTypeBuilder booleanType = typeBuilder.booleanType().id(Boolean.class.getName());
        if (defaultValue != null) {
            booleanType.defaultValue(defaultValue.toString());
        }
        return this.addField(objectType, (TypeBuilder)booleanType, name, description);
    }

    protected ObjectFieldTypeBuilder addStringField(ObjectTypeBuilder objectType, BaseTypeBuilder typeBuilder, String name, String description, String defaultValue) {
        StringTypeBuilder stringType = this.stringTypeBuilder(typeBuilder, defaultValue);
        return this.addField(objectType, (TypeBuilder)stringType, name, description);
    }

    private StringTypeBuilder stringTypeBuilder(BaseTypeBuilder typeBuilder, String defaultValue) {
        StringTypeBuilder stringType = typeBuilder.stringType().id(String.class.getName());
        if (defaultValue != null) {
            stringType.defaultValue(String.valueOf(defaultValue));
        }
        return stringType;
    }

    protected ObjectFieldTypeBuilder addPasswordField(ObjectTypeBuilder objectType, BaseTypeBuilder typeBuilder, String name, String description, String defaultValue) {
        StringTypeBuilder stringType = this.stringTypeBuilder(typeBuilder, defaultValue);
        return objectType.addField().key(name).description(description).required(false).with((TypeAnnotation)new LayoutTypeAnnotation(LayoutModel.builder().asPassword().build())).value((MetadataType)stringType.build());
    }

    protected ObjectFieldTypeBuilder addIntField(ObjectTypeBuilder objectType, BaseTypeBuilder typeBuilder, String name, String description, Integer defaultValue) {
        NumberTypeBuilder intType = typeBuilder.numberType().integer().id(Integer.class.getName());
        if (defaultValue != null) {
            intType.defaultValue(String.valueOf(defaultValue));
        }
        return this.addField(objectType, (TypeBuilder)intType, name, description);
    }

    protected ObjectFieldTypeBuilder addLongField(ObjectTypeBuilder objectType, BaseTypeBuilder typeBuilder, String name, String description, Long defaultValue) {
        NumberTypeBuilder longType = typeBuilder.numberType().integer().id(Long.class.getName());
        if (defaultValue != null) {
            longType.defaultValue(String.valueOf(defaultValue));
        }
        return this.addField(objectType, (TypeBuilder)longType, name, description);
    }

    protected ObjectFieldTypeBuilder addField(ObjectTypeBuilder objectType, TypeBuilder typeBuilder, String name, String description) {
        return objectType.addField().key(name).description(description).required(false).value(typeBuilder.build());
    }
}

