/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.mule.apache.xml.serialize.OutputFormat;
import org.mule.apache.xml.serialize.XMLSerializer;

public class GenericXmlSerializer<T> {
    private JAXBContext jaxbContext;
    private Marshaller marshaller;
    private Unmarshaller unmarshaller;

    public GenericXmlSerializer(Class<T> serializedType) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(GenericXmlSerializer.class.getClassLoader());
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{serializedType});
            this.marshaller = this.jaxbContext.createMarshaller();
            this.unmarshaller = this.jaxbContext.createUnmarshaller();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    public synchronized String serialize(T dto) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            this.marshaller.marshal(dto, this.getXmlSerializer(out).asContentHandler());
            return out.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized <T> T deserialize(String xml) {
        try {
            return (T)this.unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(xml.getBytes()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized <T> T deserialize(InputStream xml) {
        try {
            return (T)this.unmarshaller.unmarshal(xml);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private XMLSerializer getXmlSerializer(OutputStream out) {
        OutputFormat of = new OutputFormat();
        of.setCDataElements(new String[]{"^description"});
        of.setIndenting(true);
        XMLSerializer serializer = new XMLSerializer(of);
        serializer.setOutputByteStream(out);
        return serializer;
    }
}

