/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.persistence;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import org.mule.runtime.api.meta.model.XmlDslModel;

public class XmlDslModelTypeAdapter
extends TypeAdapter<XmlDslModel> {
    private static final String PREFIX = "prefix";
    private static final String NAMESPACE = "namespace";
    private static final String SCHEMA_LOCATION = "schemaLocation";
    private static final String SCHEMA_VERSION = "schemaVersion";
    private static final String XSD_FILE_NAME = "xsdFileName";

    public void write(JsonWriter out, XmlDslModel value) throws IOException {
        out.beginObject();
        out.name(PREFIX).value(value.getPrefix());
        out.name(NAMESPACE).value(value.getNamespace());
        out.name(SCHEMA_LOCATION).value(value.getSchemaLocation());
        out.name(SCHEMA_VERSION).value(value.getSchemaVersion());
        out.name(XSD_FILE_NAME).value(value.getXsdFileName());
        out.endObject();
    }

    public XmlDslModel read(JsonReader in) throws IOException {
        JsonObject json = new JsonParser().parse(in).getAsJsonObject();
        return XmlDslModel.builder().setPrefix(this.read(json, PREFIX)).setNamespace(this.read(json, NAMESPACE)).setSchemaLocation(this.read(json, SCHEMA_LOCATION)).setSchemaVersion(this.read(json, SCHEMA_VERSION)).setXsdFileName(this.read(json, XSD_FILE_NAME)).build();
    }

    private String read(JsonObject json, String memberName) {
        return json.get(memberName).getAsString();
    }
}

