/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.persistence;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.persistence.MetadataTypeGsonTypeAdapter;
import org.mule.metadata.persistence.ObjectTypeReferenceHandler;
import org.mule.runtime.api.meta.model.ImportedTypeModel;

public class ImportedTypesModelTypeAdapter
extends TypeAdapter<ImportedTypeModel> {
    private static final String EXTENSION = "extension";
    private static final String TYPE = "type";
    private final MetadataTypeGsonTypeAdapter typeAdapter;

    public ImportedTypesModelTypeAdapter(ObjectTypeReferenceHandler referenceHandler) {
        this.typeAdapter = new MetadataTypeGsonTypeAdapter(referenceHandler);
    }

    public void write(JsonWriter out, ImportedTypeModel value) throws IOException {
        out.beginObject();
        out.name(TYPE);
        this.typeAdapter.write(out, value.getImportedType());
        out.name(EXTENSION).value(value.getOriginExtensionName());
        out.endObject();
    }

    public ImportedTypeModel read(JsonReader in) throws IOException {
        JsonObject json = new JsonParser().parse(in).getAsJsonObject();
        return new ImportedTypeModel(json.get(EXTENSION).getAsString(), (MetadataType)this.typeAdapter.fromJsonTree(json.get(TYPE)));
    }
}

