/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.extension.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.dynamic.scaffold.subclass.ConstructorStrategy;
import net.bytebuddy.implementation.FixedValue;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.Empty;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.SuperMethod;
import net.bytebuddy.implementation.bind.annotation.This;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.mule.runtime.ast.extension.internal.ASTType;
import org.mule.runtime.module.extension.api.loader.java.type.AnnotationValueFetcher;
import org.mule.runtime.module.extension.api.loader.java.type.Type;

public class ASTValueFetcher<A extends Annotation>
implements AnnotationValueFetcher<A> {
    private Class<A> annotationClass;
    private final ProcessingEnvironment processingEnvironment;
    private final Supplier<Optional<AnnotationMirror>> annotationMirrorSupplier;

    ASTValueFetcher(Class<A> annotationClass, Element annotatedElememt, ProcessingEnvironment processingEnvironment) {
        this.annotationClass = annotationClass;
        this.processingEnvironment = processingEnvironment;
        this.annotationMirrorSupplier = () -> ASTValueFetcher.getAnnotationFrom(annotationClass, annotatedElememt, processingEnvironment);
    }

    private ASTValueFetcher(AnnotationMirror annotationMirror, ProcessingEnvironment processingEnvironment) {
        this.processingEnvironment = processingEnvironment;
        this.annotationMirrorSupplier = () -> Optional.ofNullable(annotationMirror);
        try {
            this.annotationClass = Class.forName(annotationMirror.getAnnotationType().toString());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(String.format("Unable to create Annotation Value Fetcher for Annotation: [%s], it doesn't exist as a Class.", annotationMirror.getAnnotationType().toString()), e);
        }
    }

    public String getStringValue(Function<A, String> function) {
        return (String)this.getConstant(function).getValue();
    }

    public <E> List<E> getArrayValue(Function<A, E[]> function) {
        AnnotationValue annotationValue = (AnnotationValue)this.getObjectValue(function);
        if (annotationValue != null) {
            List array = (List)annotationValue.getValue();
            return array.stream().map(val -> val.getValue()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public <E extends Enum> List<E> getEnumArrayValue(Function<A, E[]> function) {
        List array;
        AnnotationValue annotationValue = (AnnotationValue)this.getObjectValue(function);
        if (annotationValue != null && (array = (List)annotationValue.getValue()).size() > 0) {
            Class<?> annotationClass;
            try {
                VariableElement firstItemValue = (VariableElement)((AnnotationValue)array.get(0)).getValue();
                annotationClass = Class.forName(this.processingEnvironment.getElementUtils().getBinaryName((TypeElement)firstItemValue.getEnclosingElement()).toString());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            return array.stream().map(val -> Enum.valueOf(annotationClass, val.getValue().toString())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public List<Type> getClassArrayValue(Function<A, Class[]> function) {
        AnnotationValue value = (AnnotationValue)this.getObjectValue(function);
        if (value != null) {
            List array = (List)value.getValue();
            return array.stream().map(attr -> (DeclaredType)attr.getValue()).map(declaredType -> new ASTType((TypeElement)declaredType.asElement(), this.processingEnvironment)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public ASTType getClassValue(Function<A, Class> function) {
        Object objectValue = this.getObjectValue(function);
        if (objectValue == null) {
            return null;
        }
        return new ASTType((TypeElement)((DeclaredType)((AnnotationValue)objectValue).getValue()).asElement(), this.processingEnvironment);
    }

    public <N extends Number> N getNumberValue(Function<A, N> function) {
        return (N)((Number)this.getConstant(function).getValue());
    }

    public Boolean getBooleanValue(Function<A, Boolean> function) {
        return (Boolean)this.getConstant(function).getValue();
    }

    public <E extends Enum> E getEnumValue(Function<A, E> function) {
        Class<?> annotationClass;
        VariableElement value = (VariableElement)((AnnotationValue)this.getObjectValue(function)).getValue();
        try {
            annotationClass = Class.forName(this.processingEnvironment.getElementUtils().getBinaryName((TypeElement)value.getEnclosingElement()).toString());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return (E)Enum.valueOf(annotationClass, value.toString());
    }

    public <E extends Annotation> AnnotationValueFetcher<E> getInnerAnnotation(Function<A, E> function) {
        AnnotationValue annotationValue = (AnnotationValue)this.getObjectValue(function);
        return new ASTValueFetcher<A>((AnnotationMirror)annotationValue.getValue(), this.processingEnvironment);
    }

    public <E extends Annotation> List<AnnotationValueFetcher<E>> getInnerAnnotations(Function<A, E[]> function) {
        List annotationMirrors = (List)((AnnotationValue)this.getObjectValue(function)).getValue();
        return annotationMirrors.stream().map(am -> new ASTValueFetcher<A>((AnnotationMirror)am, this.processingEnvironment)).map(fetcher -> fetcher).collect(Collectors.toList());
    }

    private AnnotationValue getConstant(Function function) {
        return (AnnotationValue)this.getObjectValue(function);
    }

    private Object getObjectValue(Function function) {
        return this.getObjectValue(this.annotationClass, function, this.annotationMirrorSupplier);
    }

    private <T> Object getObjectValue(Class<T> annotationClass, Function retrievalValueFunction, Supplier<Optional<AnnotationMirror>> annotationMirror) {
        ReferenceInterceptor refInterceptor = new ReferenceInterceptor(annotationMirror);
        Class annotatedClass = new ByteBuddy().subclass(annotationClass, (ConstructorStrategy)ConstructorStrategy.Default.IMITATE_SUPER_CLASS).method((ElementMatcher)ElementMatchers.isToString()).intercept((Implementation)FixedValue.value((Object)"string")).method((ElementMatcher)ElementMatchers.any()).intercept((Implementation)MethodDelegation.to((Object)refInterceptor)).make().load(annotationClass.getClassLoader()).getLoaded();
        try {
            Object obj = annotatedClass.newInstance();
            retrievalValueFunction.apply(obj);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not create instance of annotated version of " + annotationClass.getName(), e);
        }
        return refInterceptor.getReference();
    }

    private static Optional<? extends AnnotationValue> getAnnotationElementValue(AnnotationMirror annotation, String name) {
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotation.getElementValues().entrySet()) {
            if (!entry.getKey().getSimpleName().toString().equals(name)) continue;
            return Optional.of(entry.getValue());
        }
        for (Element element : annotation.getAnnotationType().asElement().getEnclosedElements()) {
            if (!element.getKind().equals((Object)ElementKind.METHOD) || !element.getSimpleName().toString().equals(name)) continue;
            return Optional.ofNullable(((ExecutableElement)element).getDefaultValue());
        }
        return Optional.empty();
    }

    private static Optional<AnnotationMirror> getAnnotationFrom(Class configurationClass, Element typeElement, ProcessingEnvironment processingEnvironment) {
        TypeElement annotationTypeElement = processingEnvironment.getElementUtils().getTypeElement(configurationClass.getTypeName());
        for (AnnotationMirror annotationMirror : typeElement.getAnnotationMirrors()) {
            DeclaredType annotationType = annotationMirror.getAnnotationType();
            TypeMirror obj = annotationTypeElement.asType();
            if (!processingEnvironment.getTypeUtils().isSameType(annotationType, obj)) continue;
            return Optional.of(annotationMirror);
        }
        return Optional.empty();
    }

    private static <T> T getDefaultValue(Class<T> clazz) {
        return (T)Array.get(Array.newInstance(clazz, 1), 0);
    }

    protected static class ReferenceInterceptor {
        private Object reference = null;
        private final Supplier<Optional<AnnotationMirror>> annotationMirror;

        public ReferenceInterceptor(Supplier<Optional<AnnotationMirror>> annotationMirror) {
            this.annotationMirror = annotationMirror;
        }

        @RuntimeType
        public Object intercept(@This Object object, @Origin Method method, @AllArguments Object[] args, @SuperMethod(nullIfImpossible=true) Method superMethod, @Empty Object defaultValue) {
            this.reference = null;
            this.annotationMirror.get().ifPresent(annotation -> ASTValueFetcher.getAnnotationElementValue(annotation, method.getName()).ifPresent(this::setReference));
            return ASTValueFetcher.getDefaultValue(method.getReturnType());
        }

        private void setReference(Object object) {
            this.reference = object;
        }

        public Object getReference() {
            return this.reference;
        }
    }
}

