/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.embedded.internal;

import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.mule.maven.client.api.MavenClient;
import org.mule.runtime.module.embedded.api.ContainerConfiguration;
import org.mule.runtime.module.embedded.api.DeploymentService;
import org.mule.runtime.module.embedded.commons.api.ArtifactConfiguration;
import org.mule.runtime.module.embedded.commons.api.ContainerInfo;
import org.mule.runtime.module.embedded.commons.api.DeploymentConfiguration;
import org.mule.runtime.module.embedded.internal.AbstractEmbeddedContainer;
import org.mule.runtime.module.embedded.internal.legacy.Serializer;

public class ReflectionEmbeddedContainer
extends AbstractEmbeddedContainer<Object> {
    public ReflectionEmbeddedContainer(String muleVersion, ContainerConfiguration containerConfiguration, ClassLoader containerModulesClassLoader, List<URL> services, List<URL> serverPlugins, URL containerBaseFolder, MavenClient mavenClient) {
        super(muleVersion, containerConfiguration, containerModulesClassLoader, services, serverPlugins, containerBaseFolder, mavenClient);
    }

    @Override
    protected Object getEmbeddedController(ClassLoader embeddedControllerBootstrapClassLoader, org.mule.runtime.module.embedded.api.ContainerInfo containerInfo) throws Exception {
        Class<?> controllerClass = embeddedControllerBootstrapClassLoader.loadClass(this.getControllerClassName());
        Constructor<?> constructor = controllerClass.getConstructor(byte[].class);
        ByteArrayOutputStream containerOutputStream = new ByteArrayOutputStream(512);
        Serializer.serialize(this.adaptContainerInfo(containerInfo), (OutputStream)containerOutputStream);
        return constructor.newInstance(new Object[]{containerOutputStream.toByteArray()});
    }

    protected String getControllerClassName() {
        return "org.mule.runtime.module.embedded.impl.IsolatedEmbeddedController";
    }

    protected Serializable adaptContainerInfo(org.mule.runtime.module.embedded.api.ContainerInfo containerInfo) {
        return new ContainerInfo(containerInfo.getVersion(), containerInfo.getContainerBaseFolder(), containerInfo.getServices(), containerInfo.getServerPlugins());
    }

    protected Serializable adaptArtifactConfiguration(org.mule.runtime.module.embedded.api.ArtifactConfiguration artifactConfiguration) {
        DeploymentConfiguration deploymentConfiguration = DeploymentConfiguration.builder().lazyConnectionsEnabled(artifactConfiguration.getDeploymentConfiguration().lazyConnectionsEnabled()).lazyInitialization(artifactConfiguration.getDeploymentConfiguration().lazyInitializationEnabled()).xmlValidations(artifactConfiguration.getDeploymentConfiguration().xmlValidationsEnabled()).addArtifactAstToRegistry(artifactConfiguration.getDeploymentConfiguration().addArtifactAstToRegistry()).doNotAddToolingObjectsToRegistry(artifactConfiguration.getDeploymentConfiguration().doNotAddToolingObjectsToRegistry()).build();
        return ArtifactConfiguration.builder().artifactLocation(artifactConfiguration.getArtifactLocation()).deploymentConfiguration(deploymentConfiguration).build();
    }

    @Override
    protected void startEmbeddedController(Object embeddedController) {
        this.executeUsingExecutorService(() -> {
            this.executeUsingReflection(embeddedController, () -> embeddedController.getClass().getMethod("start", new Class[0]), Collections.emptyList());
            return null;
        });
    }

    @Override
    protected void stopEmbeddedController(Object embeddedController) {
        this.executeUsingExecutorService(() -> {
            this.executeUsingReflection(embeddedController, () -> embeddedController.getClass().getMethod("stop", new Class[0]), Collections.emptyList());
            return null;
        });
    }

    @Override
    public DeploymentService doGetDeploymentService(final Object embeddedController) {
        return new DeploymentService(){

            @Override
            public void deployApplication(org.mule.runtime.module.embedded.api.ArtifactConfiguration artifactConfiguration) {
                ReflectionEmbeddedContainer.this.executeUsingExecutorService(() -> {
                    ReflectionEmbeddedContainer.this.executeUsingReflection(embeddedController, () -> ReflectionEmbeddedContainer.this.findEmbeddedMethod(embeddedController, "deployApplication"), Collections.singletonList(ReflectionEmbeddedContainer.this.adaptArtifactConfiguration(artifactConfiguration)));
                    return null;
                });
            }

            @Override
            public void undeployApplication(String applicationName) {
                ReflectionEmbeddedContainer.this.executeUsingExecutorService(() -> {
                    ReflectionEmbeddedContainer.this.executeUsingReflection(embeddedController, () -> ReflectionEmbeddedContainer.this.findEmbeddedMethod(embeddedController, "undeployApplication"), Collections.singletonList(applicationName));
                    return null;
                });
            }

            @Override
            public void deployDomain(org.mule.runtime.module.embedded.api.ArtifactConfiguration artifactConfiguration) {
                ReflectionEmbeddedContainer.this.executeUsingExecutorService(() -> {
                    ReflectionEmbeddedContainer.this.executeUsingReflection(embeddedController, () -> ReflectionEmbeddedContainer.this.findEmbeddedMethod(embeddedController, "deployDomain"), Collections.singletonList(ReflectionEmbeddedContainer.this.adaptArtifactConfiguration(artifactConfiguration)));
                    return null;
                });
            }

            @Override
            public void undeployDomain(String domainName) {
                ReflectionEmbeddedContainer.this.executeUsingExecutorService(() -> {
                    ReflectionEmbeddedContainer.this.executeUsingReflection(embeddedController, () -> ReflectionEmbeddedContainer.this.findEmbeddedMethod(embeddedController, "undeployDomain"), Collections.singletonList(domainName));
                    return null;
                });
            }
        };
    }

    private Method findEmbeddedMethod(Object embeddedController, String methodName) {
        Method[] methods;
        for (Method method : methods = embeddedController.getClass().getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        throw new RuntimeException(new NoSuchMethodException("Method " + methodName + " not found"));
    }

    private void executeUsingReflection(Object embeddedController, UncheckedSupplier<Method> methodSupplier, List<Serializable> args) throws Exception {
        try {
            Method method = methodSupplier.get();
            List<Object> arguments = args.stream().map(arg -> {
                ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
                Serializer.serialize(arg, (OutputStream)byteOutputStream);
                return byteOutputStream.toByteArray();
            }).collect(Collectors.toList());
            method.invoke(embeddedController, arguments.toArray(new Object[arguments.size()]));
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new IllegalStateException(cause);
        }
    }

    static interface UncheckedSupplier<T> {
        public T get() throws Exception;
    }
}

