/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.embedded.internal;

import com.google.common.base.Preconditions;
import java.io.File;
import org.mule.runtime.module.embedded.api.ApplicationConfiguration;
import org.mule.runtime.module.embedded.api.DeploymentConfiguration;

public class DefaultArtifactConfigurationBuilder
implements ApplicationConfiguration.ApplicationConfigurationBuilder {
    private File applicationLocation;
    private DeploymentConfiguration deploymentConfiguration = DeploymentConfiguration.builder().build();

    @Override
    public ApplicationConfiguration.ApplicationConfigurationBuilder withApplicationLocation(File applicationLocation) {
        this.applicationLocation = applicationLocation;
        return this;
    }

    @Override
    public ApplicationConfiguration.ApplicationConfigurationBuilder withDeploymentConfiguration(DeploymentConfiguration deploymentConfiguration) {
        this.deploymentConfiguration = deploymentConfiguration;
        return this;
    }

    @Override
    public ApplicationConfiguration build() {
        return new ApplicationConfigurationImpl(this.deploymentConfiguration, this.applicationLocation);
    }

    static class ApplicationConfigurationImpl
    implements ApplicationConfiguration {
        private DeploymentConfiguration deploymentConfiguration;
        private File applicationLocation;

        public ApplicationConfigurationImpl(DeploymentConfiguration deploymentConfiguration, File applicationLocation) {
            Preconditions.checkArgument((deploymentConfiguration != null ? 1 : 0) != 0, (Object)"deploymentConfiguration cannot be null");
            Preconditions.checkArgument((applicationLocation != null ? 1 : 0) != 0, (Object)"applicationLocation cannot be null");
            this.deploymentConfiguration = deploymentConfiguration;
            this.applicationLocation = applicationLocation;
        }

        @Override
        public DeploymentConfiguration getDeploymentConfiguration() {
            return this.deploymentConfiguration;
        }

        @Override
        public File getApplicationLocation() {
            return this.applicationLocation;
        }
    }
}

