/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.connectivity.internal.persistence;


import org.mule.runtime.connectivity.api.platform.schema.ConnectivitySchemaBody;
import org.mule.runtime.connectivity.api.platform.schema.ConnectivitySchemaDefinition;
import org.mule.runtime.connectivity.api.platform.schema.ConnectivitySchemaNode;
import org.mule.runtime.connectivity.api.platform.schema.ConnectivitySchemaParameter;
import org.mule.runtime.connectivity.api.platform.schema.ConnectivitySchemaRoot;
import org.mule.runtime.connectivity.api.platform.schema.persistence.ConnectivitySchemaJsonSerializer;
import org.mule.runtime.connectivity.api.platform.schema.ConnectivitySchema;
import org.mule.runtime.connectivity.internal.platform.schema.DefaultConnectivitySchema;
import org.mule.runtime.connectivity.internal.platform.schema.DefaultConnectivitySchemaBody;
import org.mule.runtime.connectivity.internal.platform.schema.DefaultConnectivitySchemaDefinition;
import org.mule.runtime.connectivity.internal.platform.schema.DefaultConnectivitySchemaNode;
import org.mule.runtime.connectivity.internal.platform.schema.DefaultConnectivitySchemaParameter;
import org.mule.runtime.connectivity.internal.platform.schema.DefaultConnectivitySchemaRoot;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;

/**
 * Default implementation of {@link ConnectivitySchemaJsonSerializer}
 *
 * @since 1.0
 */
public class DefaultConnectivitySchemaJsonSerializer implements ConnectivitySchemaJsonSerializer {

  private Gson gson;

  public DefaultConnectivitySchemaJsonSerializer(boolean autoIndent) {
    GsonBuilder builder = new GsonBuilder()
        .registerTypeAdapterFactory(map(ConnectivitySchemaRoot.class, DefaultConnectivitySchemaRoot.class))
        .registerTypeAdapterFactory(map(ConnectivitySchemaNode.class, DefaultConnectivitySchemaNode.class))
        .registerTypeAdapterFactory(map(ConnectivitySchemaBody.class, DefaultConnectivitySchemaBody.class))
        .registerTypeAdapterFactory(map(ConnectivitySchemaDefinition.class, DefaultConnectivitySchemaDefinition.class))
        .registerTypeAdapterFactory(map(ConnectivitySchemaNode.class, DefaultConnectivitySchemaNode.class))
        .registerTypeAdapterFactory(map(ConnectivitySchemaParameter.class, DefaultConnectivitySchemaParameter.class));

    if (autoIndent) {
      builder.setPrettyPrinting();
    }

    gson = builder.create();
  }

  private <S, T extends S> TypeAdapterFactory map(Class<S> abstractType, Class<T> concreteType) {
    return new DefaultImplementationTypeAdapterFactory<>(abstractType, concreteType);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String serialize(ConnectivitySchema schema) {
    return gson.toJson(schema);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ConnectivitySchema deserialize(String json) {
    return gson.fromJson(json, DefaultConnectivitySchema.class);
  }
}
