/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.api.util;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentGenerationInformation;
import org.mule.runtime.ast.api.ComponentMetadataAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.util.AstTraversalDirection;

public abstract class BaseComponentAstDecorator
implements ComponentAst {
    private final ComponentAst decorated;

    public BaseComponentAstDecorator(ComponentAst decorated) {
        this.decorated = decorated;
    }

    protected ComponentAst getDecorated() {
        return this.decorated;
    }

    @Override
    public Stream<ComponentAst> recursiveStream(AstTraversalDirection direction) {
        return StreamSupport.stream(this.recursiveSpliterator(direction), false);
    }

    @Override
    public Stream<ComponentAst> recursiveStream() {
        return this.recursiveStream(AstTraversalDirection.TOP_DOWN);
    }

    @Override
    public Spliterator<ComponentAst> recursiveSpliterator() {
        return this.recursiveSpliterator(AstTraversalDirection.TOP_DOWN);
    }

    @Override
    public Spliterator<ComponentAst> recursiveSpliterator(AstTraversalDirection direction) {
        return direction.recursiveSpliterator(this);
    }

    @Override
    public List<ComponentAst> directChildren() {
        return this.decorated.directChildren();
    }

    @Override
    public Stream<ComponentAst> directChildrenStream() {
        return this.decorated.directChildrenStream();
    }

    @Override
    public Spliterator<ComponentAst> directChildrenSpliterator() {
        return this.directChildrenStream().spliterator();
    }

    @Override
    public Collection<ComponentParameterAst> getParameters() {
        return this.decorated.getParameters();
    }

    @Override
    public ComponentParameterAst getParameter(String groupName, String paramName) {
        return this.decorated.getParameter(groupName, paramName);
    }

    @Override
    public ExtensionModel getExtensionModel() {
        return this.decorated.getExtensionModel();
    }

    @Override
    public <M> Optional<M> getModel(Class<M> modelClass) {
        return this.decorated.getModel(modelClass);
    }

    @Override
    public MetadataType getType() {
        return this.decorated.getType();
    }

    @Override
    public Map<String, Object> getAnnotations() {
        return this.decorated.getAnnotations();
    }

    @Override
    public ComponentMetadataAst getMetadata() {
        return this.decorated.getMetadata();
    }

    @Override
    public ComponentLocation getLocation() {
        return this.decorated.getLocation();
    }

    @Override
    public ComponentIdentifier getIdentifier() {
        return this.decorated.getIdentifier();
    }

    @Override
    public TypedComponentIdentifier.ComponentType getComponentType() {
        return this.decorated.getComponentType();
    }

    @Override
    public Optional<String> getComponentId() {
        return this.decorated.getComponentId();
    }

    @Override
    public ComponentGenerationInformation getGenerationInformation() {
        return this.decorated.getGenerationInformation();
    }

    public String toString() {
        return this.getComponentId().map(n -> "" + n + "(" + this.getIdentifier().toString() + ")").orElse(this.getIdentifier().toString()) + (this.getLocation() != null ? " @ " + this.getLocation().getLocation() : "");
    }
}

