/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.stream;

import java.util.ArrayList;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.util.AstTraversalDirection;
import org.mule.runtime.ast.api.util.MuleAstUtils;

public abstract class ComponentAstSpliteratorStrategy
implements Spliterator<ComponentAst> {
    private final ComponentAst component;
    private final AstTraversalDirection direction;
    private boolean rootProcessed = false;
    private Spliterator<ComponentAst> childrenSpliterator;
    private Spliterator<ComponentAst> currentChildSpliterator;

    public ComponentAstSpliteratorStrategy(ComponentAst component, AstTraversalDirection direction) {
        this.component = component;
        this.direction = direction;
    }

    protected abstract boolean tryAdvanceBeforeChildrenConsumed(Consumer<? super ComponentAst> var1);

    protected abstract boolean tryAdvanceAfterChildrenConsumed(Consumer<? super ComponentAst> var1);

    protected boolean tryAdvanceOverComponentAst(Consumer<? super ComponentAst> action) {
        if (!this.rootProcessed) {
            this.rootProcessed = true;
            action.accept(this.component);
            return true;
        }
        return false;
    }

    @Override
    public boolean tryAdvance(Consumer<? super ComponentAst> action) {
        if (this.tryAdvanceBeforeChildrenConsumed(action)) {
            return true;
        }
        this.trySplit();
        if (this.currentChildSpliterator != null) {
            if (this.currentChildSpliterator.tryAdvance(action)) {
                return true;
            }
            this.currentChildSpliterator = null;
            return this.tryAdvance(action);
        }
        if (this.childrenSpliterator.tryAdvance((? super T componentAst) -> {
            this.currentChildSpliterator = componentAst.recursiveSpliterator(this.direction);
        })) {
            return this.tryAdvance(action);
        }
        return this.tryAdvanceAfterChildrenConsumed(action);
    }

    @Override
    public Spliterator<ComponentAst> trySplit() {
        if (this.childrenSpliterator == null) {
            ArrayList paramsChildren = new ArrayList();
            if (this.component.getModel(ParameterizedModel.class).isPresent()) {
                this.component.getParameters().forEach(param -> MuleAstUtils.doOnParamComponents(param, paramsChildren::add));
            }
            this.childrenSpliterator = Stream.concat(this.component.directChildrenStream(), paramsChildren.stream()).spliterator();
        }
        return null;
    }

    @Override
    public long estimateSize() {
        return 1L + this.component.directChildrenStream().mapToLong(inner -> inner.recursiveSpliterator(this.direction).estimateSize()).sum();
    }

    @Override
    public int characteristics() {
        return 17745;
    }
}

