/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.xml.reader;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.ast.api.ComponentMetadataAst;
import org.mule.runtime.ast.api.ImportedResource;
import org.mule.runtime.ast.api.builder.ArtifactAstBuilder;
import org.mule.runtime.ast.api.builder.ComponentAstBuilder;
import org.mule.runtime.ast.api.builder.NamespaceDefinitionBuilder;
import org.mule.runtime.ast.api.xml.AstXmlParser;
import org.mule.runtime.ast.api.xml.AstXmlParserAttribute;
import org.mule.runtime.ast.internal.DefaultComponentMetadataAst;
import org.mule.runtime.ast.internal.builder.ImportedResourceBuilder;
import org.mule.runtime.dsl.api.xml.parser.XmlApplicationParser;
import org.mule.runtime.dsl.internal.xml.parser.XmlMetadataAnnotations;
import org.mule.runtime.internal.dsl.DslConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ComponentAstReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentAstReader.class);
    private static final QName DECLARED_PREFIX_QNAME = QName.valueOf("DECLARED_PREFIX");
    private static final String SCHEMA_LOCATION = "xsi:schemaLocation";
    private static final String MODULE_PREFIX_ATTRIBUTE = "prefix";
    private static final String MODULE_NAMESPACE_ATTRIBUTE = "namespace";
    private static final ComponentIdentifier DESCRIPTION_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").namespaceUri(DslConstants.CORE_NAMESPACE).name("description").build();

    public void extractComponentDefinitionModel(XmlApplicationParser parser, Element element, String resourceName, URL resourceUrl, List<ImportedResource> importChain, Supplier<ComponentAstBuilder> childFactory, DefaultComponentMetadataAst.Builder parentMetadata) {
        ComponentIdentifier elementIdentifier = this.buildIdentifier(parser, element);
        if (DESCRIPTION_IDENTIFIER.equals(elementIdentifier)) {
            if (parentMetadata != null) {
                parentMetadata.putDocAttribute("description", element.getTextContent());
            }
            return;
        }
        ComponentAstBuilder componentAstBuilder = childFactory.get();
        componentAstBuilder.withIdentifier(elementIdentifier);
        DefaultComponentMetadataAst.Builder metadata = this.extractMetadata(element, resourceName, resourceUrl, importChain);
        this.processAttributes(componentAstBuilder, element);
        this.processAnnotations(componentAstBuilder, element);
        this.processChildNodesRecursively(componentAstBuilder, metadata, parser, element, resourceName, resourceUrl, importChain);
        componentAstBuilder.withMetadata(metadata.build());
    }

    private ComponentIdentifier buildIdentifier(XmlApplicationParser parser, Element element) {
        String namespace = parser.parseNamespace((Node)element);
        String namespaceUri = parser.parseNamespaceUri((Node)element);
        ComponentIdentifier identifier = ComponentIdentifier.builder().namespace(namespace == null ? "mule" : namespace).namespaceUri(namespaceUri == null ? DslConstants.CORE_NAMESPACE : namespaceUri).name(parser.parseIdentifier((Node)element)).build();
        return identifier;
    }

    private DefaultComponentMetadataAst.Builder extractMetadata(Element element, String resourceName, URL resourceUrl, List<ImportedResource> importChain) {
        Node nameAttribute;
        XmlMetadataAnnotations userData;
        DefaultComponentMetadataAst.Builder metadataBuilder = DefaultComponentMetadataAst.builder().setFileName(resourceName).setImportChain(importChain);
        if (resourceUrl != null) {
            URI fileUri;
            try {
                fileUri = resourceUrl.toURI();
            }
            catch (URISyntaxException e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("File URI is not RFC 2396 compliant: %s", resourceUrl)), (Throwable)e);
            }
            metadataBuilder.setFileUri(fileUri);
        }
        if ((userData = (XmlMetadataAnnotations)element.getUserData("metadataAnnotations")) != null) {
            metadataBuilder.setStartLine(userData.getOpeningTagBoundaries().getStartLineNumber()).setEndLine(userData.getClosingTagBoundaries().getEndLineNumber()).setStartColumn(userData.getOpeningTagBoundaries().getStartColumnNumber()).setEndColumn(userData.getClosingTagBoundaries().getEndColumnNumber()).setSourceCode(userData.getElementString()).putParserAttribute(AstXmlParserAttribute.OPENING_TAG_START_LINE, (Object)userData.getOpeningTagBoundaries().getStartLineNumber()).putParserAttribute(AstXmlParserAttribute.OPENING_TAG_START_COLUMN, (Object)userData.getOpeningTagBoundaries().getStartColumnNumber()).putParserAttribute(AstXmlParserAttribute.OPENING_TAG_END_LINE, (Object)userData.getOpeningTagBoundaries().getEndLineNumber()).putParserAttribute(AstXmlParserAttribute.OPENING_TAG_END_COLUMN, (Object)userData.getOpeningTagBoundaries().getEndColumnNumber()).putParserAttribute(AstXmlParserAttribute.CLOSING_TAG_START_LINE, (Object)userData.getClosingTagBoundaries().getStartLineNumber()).putParserAttribute(AstXmlParserAttribute.CLOSING_TAG_START_COLUMN, (Object)userData.getClosingTagBoundaries().getStartColumnNumber()).putParserAttribute(AstXmlParserAttribute.CLOSING_TAG_END_LINE, (Object)userData.getClosingTagBoundaries().getEndLineNumber()).putParserAttribute(AstXmlParserAttribute.CLOSING_TAG_END_COLUMN, (Object)userData.getClosingTagBoundaries().getEndColumnNumber());
            if (userData.isSelfClosing()) {
                metadataBuilder.putParserAttribute(AstXmlParserAttribute.IS_SELF_CLOSING, (Object)true);
            }
        }
        if ((nameAttribute = element.getAttributes().getNamedItemNS(Component.Annotations.NAME_ANNOTATION_KEY.getNamespaceURI(), Component.Annotations.NAME_ANNOTATION_KEY.getLocalPart())) != null) {
            this.addCustomAttribute(metadataBuilder, Component.Annotations.NAME_ANNOTATION_KEY, nameAttribute.getNodeValue());
        }
        if (element.getPrefix() != null) {
            this.addCustomAttribute(metadataBuilder, DECLARED_PREFIX_QNAME, element.getPrefix());
        }
        for (int i = 0; i < element.getAttributes().getLength(); ++i) {
            Node attributeNode = element.getAttributes().item(i);
            if (attributeNode.getNamespaceURI() == null) continue;
            this.addCustomAttribute(metadataBuilder, new QName(attributeNode.getNamespaceURI(), attributeNode.getLocalName()), attributeNode.getNodeValue());
        }
        return metadataBuilder;
    }

    private void processAttributes(ComponentAstBuilder componentAstBuilder, Element element) {
        this.processAttributes(element, n -> StringUtils.isEmpty((CharSequence)n.getNamespaceURI()), node -> componentAstBuilder.withRawParameter(node.getNodeName(), node.getNodeValue()));
    }

    private void processAnnotations(ComponentAstBuilder componentAstBuilder, Element element) {
        this.processAttributes(element, n -> !StringUtils.isEmpty((CharSequence)n.getNamespaceURI()), node -> componentAstBuilder.withAnnotation(new QName(node.getNamespaceURI(), node.getLocalName()).toString(), (Object)node.getNodeValue()));
    }

    private Map<String, String> calculateSchemaLocations(String schLoc) {
        LOGGER.debug("calculateSchemaLocations: {}", (Object)schLoc);
        HashMap<String, String> schemaLocations = new HashMap<String, String>();
        String[] pairs = schLoc.trim().split("\\s+");
        for (int i = 0; i < pairs.length; i += 2) {
            if (i + 1 < pairs.length) {
                schemaLocations.put(pairs[i], pairs[i + 1]);
                continue;
            }
            LOGGER.warn("namespaceUri without location: {}", (Object)pairs[i]);
        }
        return schemaLocations;
    }

    public void processAttributes(ArtifactAstBuilder astBuilder, Element element) {
        NamespaceDefinitionBuilder namespaceDefinitionBuilder = NamespaceDefinitionBuilder.builder();
        this.processAttributes(element, n -> true, node -> {
            String name = node.getNodeName();
            String value = node.getNodeValue();
            if (name.equals(SCHEMA_LOCATION)) {
                this.calculateSchemaLocations(value).forEach((schLoc, loc) -> namespaceDefinitionBuilder.withSchemaLocation(schLoc, loc));
            } else if (name.equals(MODULE_NAMESPACE_ATTRIBUTE)) {
                namespaceDefinitionBuilder.withNamespace(value);
            } else if (name.equals(MODULE_PREFIX_ATTRIBUTE)) {
                namespaceDefinitionBuilder.withPrefix(value);
            } else {
                namespaceDefinitionBuilder.withUnresolvedNamespace(name, value);
            }
        });
        astBuilder.withNamespaceDefinition(namespaceDefinitionBuilder.build());
    }

    private void processAttributes(Element element, Predicate<Node> filter, Consumer<Node> consumer) {
        NamedNodeMap attributes = element.getAttributes();
        if (element.hasAttributes()) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node attribute = attributes.item(i);
                if (!filter.test(attribute)) continue;
                consumer.accept(attribute);
            }
        }
    }

    private void processChildNodesRecursively(ComponentAstBuilder componentAstBuilder, DefaultComponentMetadataAst.Builder metadata, XmlApplicationParser parser, Element element, String resourceName, URL resourceUrl, List<ImportedResource> importChain) {
        if (element.hasChildNodes()) {
            NodeList children = element.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (XmlApplicationParser.isTextContent((Node)child)) {
                    componentAstBuilder.withBodyParameter(child.getNodeValue());
                    if (child.getNodeType() != 4) continue;
                    metadata.putParserAttribute(AstXmlParserAttribute.IS_CDATA, (Object)Boolean.TRUE);
                    break;
                }
                if (!(child instanceof Element)) continue;
                if (child.getNamespaceURI().equals(DslConstants.CORE_NAMESPACE) && child.getLocalName().endsWith(AstXmlParser.ANNOTATIONS_IDENTIFIER.getName())) {
                    this.processNestedAnnotations((Element)child, metadata);
                    continue;
                }
                this.extractComponentDefinitionModel(parser, (Element)child, resourceName, resourceUrl, importChain, () -> ((ComponentAstBuilder)componentAstBuilder).addChildComponent(), metadata);
            }
        }
    }

    private void processNestedAnnotations(Element element, DefaultComponentMetadataAst.Builder metadata) {
        if (element.hasChildNodes()) {
            NodeList children = element.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (!(child instanceof Element)) continue;
                this.addCustomAttribute(metadata, new QName(child.getNamespaceURI(), child.getLocalName(), child.getPrefix()), child.getTextContent().trim());
            }
        }
    }

    private void addCustomAttribute(DefaultComponentMetadataAst.Builder metadataBuilder, QName qname, Object value) {
        if (StringUtils.isEmpty((CharSequence)qname.getNamespaceURI()) || "http://www.mulesoft.org/schema/mule/parser-metadata".equals(qname.getNamespaceURI())) {
            metadataBuilder.putParserAttribute(qname.getLocalPart(), value);
        } else if ("http://www.mulesoft.org/schema/mule/documentation".equals(qname.getNamespaceURI())) {
            metadataBuilder.putDocAttribute(qname.getLocalPart(), value.toString());
        }
    }

    public void extractImport(ArtifactAstBuilder astBuilder, Element importNode, String resourceName, URL resourceUrl, List<ImportedResource> importChain) {
        ComponentMetadataAst metadata = this.extractMetadata(importNode, resourceName, resourceUrl, importChain).build();
        if (!importNode.hasAttribute("file")) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("<import> does not have a file attribute defined. At file '%s', at line %s", metadata.getFileName(), metadata.getStartLine())));
        }
        astBuilder.withImportedResource(ImportedResourceBuilder.builder().withResourceLocation(importNode.getAttribute("file")).withMetadata(metadata).build());
    }
}

