/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.connection;

import java.util.Optional;
import org.mule.api.annotation.NoExtend;
import org.mule.api.annotation.NoInstantiate;
import org.mule.runtime.api.message.ErrorType;

@NoExtend
public class ConnectionValidationResult {
    private boolean validationStatus;
    private String message;
    private ErrorType errorType;
    private Exception exception;

    @NoInstantiate
    protected ConnectionValidationResult() {
    }

    private ConnectionValidationResult(boolean validationStatus, String message, Exception exception) {
        this(validationStatus, message, null, exception);
    }

    private ConnectionValidationResult(boolean validationStatus, String message, ErrorType errorType, Exception exception) {
        this.validationStatus = validationStatus;
        this.message = message;
        this.errorType = errorType;
        this.exception = exception;
    }

    public static ConnectionValidationResult success() {
        return new ConnectionValidationResult(true, null, null, null);
    }

    public static ConnectionValidationResult failure(String message, Exception exception) {
        return new ConnectionValidationResult(false, message, exception);
    }

    public static ConnectionValidationResult failure(String message, ErrorType errorType, Exception exception) {
        return new ConnectionValidationResult(false, message, errorType, exception);
    }

    public boolean isValid() {
        return this.validationStatus;
    }

    public String getMessage() {
        return this.message;
    }

    public Optional<ErrorType> getErrorType() {
        return Optional.ofNullable(this.errorType);
    }

    public Exception getException() {
        return this.exception;
    }

    public String toString() {
        if (this.validationStatus) {
            return "ConnectionValidationResult(success)";
        }
        return "ConnectionValidationResult(" + this.errorType + ": " + this.message + ")";
    }
}

