/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.store;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.TemplateObjectStore;

public class SimpleMemoryObjectStore<T extends Serializable>
extends TemplateObjectStore<T>
implements ObjectStore<T> {
    private Map<String, T> map = new ConcurrentHashMap<String, T>();

    @Override
    public boolean isPersistent() {
        return false;
    }

    @Override
    protected boolean doContains(String key) throws ObjectStoreException {
        return this.map.containsKey(key);
    }

    @Override
    protected void doStore(String key, T value) throws ObjectStoreException {
        if (value == null) {
            throw new ObjectStoreException(I18nMessageFactory.createStaticMessage("The required object/property \"value\" is null"));
        }
        this.map.put(key, value);
    }

    @Override
    protected T doRetrieve(String key) throws ObjectStoreException {
        return (T)((Serializable)this.map.get(key));
    }

    @Override
    public void clear() throws ObjectStoreException {
        this.map.clear();
    }

    @Override
    protected T doRemove(String key) {
        return (T)((Serializable)this.map.remove(key));
    }

    @Override
    public Map<String, T> retrieveAll() throws ObjectStoreException {
        return Collections.unmodifiableMap(this.map);
    }

    @Override
    public void open() throws ObjectStoreException {
    }

    @Override
    public void close() throws ObjectStoreException {
    }

    @Override
    public List<String> allKeys() throws ObjectStoreException {
        return new ArrayList<String>(this.map.keySet());
    }
}

