/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.el;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.mule.metadata.message.api.el.TypeBindings;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.CompiledExpression;
import org.mule.runtime.api.el.ExpressionCompilationException;
import org.mule.runtime.api.el.ExpressionExecutionException;
import org.mule.runtime.api.el.ExpressionLanguageSession;
import org.mule.runtime.api.el.ModuleElementName;
import org.mule.runtime.api.el.ValidationResult;
import org.mule.runtime.api.el.validation.ScopePhaseValidationMessages;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;

public interface ExpressionLanguage
extends Disposable {
    public void addGlobalBindings(BindingContext var1);

    public TypedValue<?> evaluate(String var1, BindingContext var2) throws ExpressionExecutionException;

    public TypedValue<?> evaluate(String var1, DataType var2, BindingContext var3) throws ExpressionExecutionException;

    public TypedValue<?> evaluateLogExpression(String var1, BindingContext var2) throws ExpressionExecutionException;

    public ValidationResult validate(String var1);

    default public ScopePhaseValidationMessages collectScopePhaseValidationMessages(String script, String nameIdentifier, TypeBindings bindings) {
        throw new UnsupportedOperationException("The current ExpressionLanguage does not support collectScopePhaseValidationMessages() method. Please update the expression language version");
    }

    public Iterator<TypedValue<?>> split(String var1, BindingContext var2);

    default public CompiledExpression compile(final String expression, BindingContext context) throws ExpressionCompilationException {
        return new CompiledExpression(){

            @Override
            public String expression() {
                return expression;
            }

            @Override
            public Optional<MediaType> outputType() {
                return Optional.empty();
            }

            @Override
            public List<ModuleElementName> externalDependencies() {
                return Collections.emptyList();
            }
        };
    }

    default public CompiledExpression compile(final String nameIdentifier, final String expression, BindingContext context) throws ExpressionCompilationException {
        return new CompiledExpression(){

            @Override
            public String expression() {
                return expression;
            }

            @Override
            public Optional<MediaType> outputType() {
                return Optional.empty();
            }

            @Override
            public List<ModuleElementName> externalDependencies() {
                return Collections.emptyList();
            }

            @Override
            public String nameIdentifier() {
                return nameIdentifier;
            }
        };
    }

    @Override
    default public void dispose() {
    }

    default public ExpressionLanguageSession openSession(final BindingContext context) {
        final ExpressionLanguage expressionLanguage = this;
        return new ExpressionLanguageSession(){

            @Override
            public TypedValue<?> evaluate(String expression) throws ExpressionExecutionException {
                return expressionLanguage.evaluate(expression, context);
            }

            @Override
            public TypedValue<?> evaluate(String expression, DataType expectedOutputType) throws ExpressionExecutionException {
                return expressionLanguage.evaluate(expression, expectedOutputType, context);
            }

            @Override
            public TypedValue<?> evaluate(String expression, long timeout) throws ExpressionExecutionException {
                return expressionLanguage.evaluate(expression, context);
            }

            @Override
            public TypedValue<?> evaluateLogExpression(String expression) throws ExpressionExecutionException {
                return expressionLanguage.evaluateLogExpression(expression, context);
            }

            @Override
            public Iterator<TypedValue<?>> split(String expression) {
                return expressionLanguage.split(expression, context);
            }

            @Override
            public TypedValue<?> evaluate(CompiledExpression expression) throws ExpressionExecutionException {
                return this.evaluate(expression.expression());
            }

            @Override
            public TypedValue<?> evaluate(CompiledExpression expression, DataType expectedOutputType) throws ExpressionExecutionException {
                return this.evaluate(expression.expression(), expectedOutputType);
            }

            @Override
            public TypedValue<?> evaluate(CompiledExpression expression, long timeout) throws ExpressionExecutionException {
                return this.evaluate(expression.expression(), timeout);
            }

            @Override
            public TypedValue<?> evaluateLogExpression(CompiledExpression expression) throws ExpressionExecutionException {
                return this.evaluateLogExpression(expression.expression());
            }

            @Override
            public Iterator<TypedValue<?>> split(CompiledExpression expression) {
                return this.split(expression.expression());
            }

            @Override
            public void close() {
            }
        };
    }
}

