/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.component.location;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mule.api.annotation.NoImplement;
import org.mule.runtime.api.util.NameValidationUtil;
import org.mule.runtime.api.util.Preconditions;

@NoImplement
public interface Location {
    public static final String SOURCE = "source";
    public static final String CONNECTION = "connection";
    public static final String PROCESSORS = "processors";
    public static final String ERROR_HANDLER = "errorHandler";

    public String getGlobalName();

    public List<String> getParts();

    public static Builder builder() {
        return new LocationBuilder();
    }

    public static Builder builderFromStringRepresentation(String location) {
        String[] parts = location.split("/");
        Builder builder = Location.builder();
        builder = builder.globalName(parts[0]);
        for (int i = 1; i < parts.length; ++i) {
            builder = builder.addPart(parts[i]);
        }
        return builder;
    }

    public static class LocationBuilder
    implements Builder {
        private static final String PLACEHOLDER_PREFIX = "${";
        private static final String PLACEHOLDER_SUFFIX = "}";
        private LocationImpl location = new LocationImpl();
        private boolean globalNameAlreadySet = false;

        @Override
        public Builder globalName(String globalName) {
            this.globalNameAlreadySet = true;
            if (!LocationBuilder.isPlaceholder(globalName)) {
                NameValidationUtil.verifyStringDoesNotContainsReservedCharacters(globalName);
            }
            LocationBuilder locationBuilder = this.builderCopy();
            locationBuilder.location.parts.add(0, globalName);
            return locationBuilder;
        }

        private static boolean isPlaceholder(String string) {
            return string.startsWith(PLACEHOLDER_PREFIX) && string.endsWith(PLACEHOLDER_SUFFIX);
        }

        @Override
        public Builder addPart(String part) {
            NameValidationUtil.verifyStringDoesNotContainsReservedCharacters(part);
            this.verifyIndexPartAfterProcessor(part);
            LocationBuilder locationBuilder = this.builderCopy();
            locationBuilder.location.parts.addLast(part);
            return locationBuilder;
        }

        @Override
        public Builder addConnectionPart() {
            this.checkIsNotFirstPart(Location.CONNECTION);
            LocationBuilder locationBuilder = this.builderCopy();
            locationBuilder.location.parts.add(Location.CONNECTION);
            return locationBuilder;
        }

        @Override
        public Builder addSourcePart() {
            this.checkIsNotFirstPart(Location.SOURCE);
            LocationBuilder locationBuilder = this.builderCopy();
            locationBuilder.location.parts.add(Location.SOURCE);
            return locationBuilder;
        }

        @Override
        public Builder addProcessorsPart() {
            this.checkIsNotFirstPart(Location.PROCESSORS);
            LocationBuilder locationBuilder = this.builderCopy();
            locationBuilder.location.parts.add(Location.PROCESSORS);
            return locationBuilder;
        }

        @Override
        public Builder addErrorHandlerPart() {
            this.checkIsNotFirstPart(Location.ERROR_HANDLER);
            LocationBuilder locationBuilder = this.builderCopy();
            locationBuilder.location.parts.add(Location.ERROR_HANDLER);
            return locationBuilder;
        }

        private void checkIsNotFirstPart(String partName) {
            Preconditions.checkState(!this.location.parts.isEmpty(), "[" + partName + "] cannot be the first part");
        }

        @Override
        public Builder addIndexPart(int index) {
            Preconditions.checkState(!this.location.parts.isEmpty(), "An index cannot be the first part");
            LocationBuilder locationBuilder = this.builderCopy();
            locationBuilder.location.parts.addLast(String.valueOf(index));
            return locationBuilder;
        }

        @Override
        public Builder parts(List<String> parts) {
            this.location.parts = new LinkedList<String>(parts);
            return this;
        }

        private void verifyIndexPartAfterProcessor(String part) {
            if (((String)this.location.parts.getLast()).equals(Location.PROCESSORS)) {
                Preconditions.checkState(StringUtils.isNumeric((CharSequence)part), "Only an index part can follow a processors part, was '" + part + "'");
            }
        }

        private LocationBuilder builderCopy() {
            LocationBuilder locationBuilder = new LocationBuilder();
            locationBuilder.globalNameAlreadySet = this.globalNameAlreadySet;
            locationBuilder.location.parts.addAll(this.location.parts);
            return locationBuilder;
        }

        @Override
        public Location build() {
            Preconditions.checkState(this.globalNameAlreadySet, "global component name must be set");
            return this.location;
        }
    }

    public static interface Builder {
        public Builder globalName(String var1);

        public Builder addPart(String var1);

        public Builder addConnectionPart();

        public Builder addSourcePart();

        public Builder addProcessorsPart();

        public Builder addErrorHandlerPart();

        public Builder addIndexPart(int var1);

        public Builder parts(List<String> var1);

        public Location build();
    }

    public static class LocationImpl
    implements Location {
        protected static final String PARTS_SEPARATOR = "/";
        private LinkedList<String> parts = new LinkedList();
        private String asString;

        @Override
        public String getGlobalName() {
            return this.parts.get(0);
        }

        @Override
        public List<String> getParts() {
            return this.parts.subList(1, this.parts.size());
        }

        public String toString() {
            if (this.asString == null) {
                this.asString = String.join((CharSequence)PARTS_SEPARATOR, this.parts);
            }
            return this.asString;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LocationImpl location = (LocationImpl)o;
            return this.parts.equals(location.parts);
        }

        public int hashCode() {
            return this.parts.hashCode();
        }
    }
}

