/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.meta.model.display;

import java.util.Objects;
import java.util.Optional;
import org.mule.runtime.api.meta.model.display.ClassValueModel;
import org.mule.runtime.api.meta.model.display.PathModel;

public final class DisplayModel {
    private String displayName;
    private String summary;
    private String example;
    private PathModel pathModel;
    private ClassValueModel classValueModel;

    public static DisplayModelBuilder builder() {
        return new DisplayModelBuilder();
    }

    private DisplayModel() {
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getExample() {
        return this.example;
    }

    public Optional<PathModel> getPathModel() {
        return Optional.ofNullable(this.pathModel);
    }

    public Optional<ClassValueModel> getClassValueModel() {
        return Optional.ofNullable(this.classValueModel);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DisplayModel) {
            DisplayModel other = (DisplayModel)obj;
            return Objects.equals(other.getDisplayName(), this.getDisplayName()) && Objects.equals(other.getSummary(), this.getSummary()) && Objects.equals(other.getExample(), this.getExample()) && Objects.equals(other.getPathModel(), this.getPathModel()) && Objects.equals(other.getClassValueModel(), this.getClassValueModel());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.displayName, this.summary, this.example, this.classValueModel);
    }

    public static final class DisplayModelBuilder {
        private final DisplayModel product = new DisplayModel();

        private DisplayModelBuilder() {
        }

        public DisplayModelBuilder displayName(String displayName) {
            this.product.displayName = displayName;
            return this;
        }

        public DisplayModelBuilder summary(String summary) {
            this.product.summary = summary;
            return this;
        }

        public DisplayModelBuilder example(String example) {
            this.product.example = example;
            return this;
        }

        public DisplayModelBuilder path(PathModel pathModel) {
            this.product.pathModel = pathModel;
            return this;
        }

        public DisplayModelBuilder classValue(ClassValueModel classValueModel) {
            this.product.classValueModel = classValueModel;
            return this;
        }

        public DisplayModel build() {
            return this.product;
        }
    }
}

