/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.functional;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

public class Either<L, R> {
    private static final Either<?, ?> EMPTY = new Either<Object, Object>(null, null);
    private final L left;
    private final R right;

    public static <L, R> Either<L, R> empty() {
        return EMPTY;
    }

    public static <L, R> Either<L, R> left(L value) {
        if (value == null) {
            return EMPTY;
        }
        return new Either<L, Object>(value, null);
    }

    public static <L, R> Either<L, R> left(L value, Class<R> rightClass) {
        return Either.left(value);
    }

    public static <L, R> Either<L, R> right(R value) {
        if (value == null) {
            return EMPTY;
        }
        return new Either<Object, R>(null, value);
    }

    public static <L, R> Either<L, R> right(Class<L> leftClass, R value) {
        return Either.right(value);
    }

    private Either(L l, R r) {
        this.left = l;
        this.right = r;
    }

    public <T> T reduce(Function<? super L, ? extends T> leftFunc, Function<? super R, ? extends T> rightFunc) {
        if (this.isLeft()) {
            return leftFunc.apply(this.left);
        }
        return this.isRight() ? (T)rightFunc.apply((R)this.right) : null;
    }

    public <T> Either<T, R> mapLeft(Function<? super L, ? extends T> func) {
        if (this.left == null) {
            return this;
        }
        return new Either<T, R>(func.apply(this.left), this.right);
    }

    public void applyLeft(Consumer<? super L> consumer) {
        if (this.left != null) {
            consumer.accept(this.left);
        }
    }

    public void applyRight(Consumer<? super R> consumer) {
        if (this.right != null) {
            consumer.accept(this.right);
        }
    }

    public <T> Either<L, T> mapRight(Function<? super R, ? extends T> func) {
        if (this.right == null) {
            return this;
        }
        return new Either<L, T>(this.left, func.apply(this.right));
    }

    public void apply(Consumer<? super L> leftConsumer, Consumer<? super R> rightConsumer) {
        this.applyLeft(leftConsumer);
        this.applyRight(rightConsumer);
    }

    public boolean isLeft() {
        return this.left != null;
    }

    public boolean isRight() {
        return this.right != null;
    }

    public L getLeft() {
        return this.left;
    }

    public R getRight() {
        return this.right;
    }

    public <T> Optional<T> getValue() {
        if (this.left != null) {
            return Optional.of(this.left);
        }
        if (this.right != null) {
            return Optional.of(this.right);
        }
        return Optional.empty();
    }

    public String toString() {
        if (this.left != null) {
            return String.format("%s - left: { %s }", this.getClass().getSimpleName(), this.left.toString());
        }
        if (this.right != null) {
            return String.format("%s - right: { %s }", this.getClass().getSimpleName(), this.right.toString());
        }
        return String.format("%s - empty", this.getClass().getSimpleName());
    }
}

