/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.internal.util.xmlsecurity;

import java.util.Objects;
import org.mule.runtime.internal.util.xmlsecurity.DefaultXMLSecureFactories;

public abstract class XMLFactoryConfig {
    protected Boolean externalEntities;
    protected Boolean expandEntities;
    protected String schemaLanguage;
    protected String factoryName;

    public XMLFactoryConfig(DefaultXMLSecureFactories secureFactories, String schemaLanguage, String factoryName) {
        this.externalEntities = secureFactories.getExternalEntities();
        this.expandEntities = secureFactories.getExpandEntities();
        this.schemaLanguage = schemaLanguage;
        this.factoryName = factoryName;
    }

    public boolean equals(Object other) {
        if (other instanceof XMLFactoryConfig) {
            XMLFactoryConfig otherConfig = (XMLFactoryConfig)other;
            return this.externalEntities.equals(otherConfig.externalEntities) && this.expandEntities.equals(otherConfig.expandEntities) && Objects.equals(this.schemaLanguage, otherConfig.schemaLanguage) && this.factoryName.equals(otherConfig.factoryName);
        }
        return false;
    }

    public int hashCode() {
        int primeNumber = 31;
        int result = this.externalEntities.hashCode();
        result = 31 * result + this.expandEntities.hashCode();
        if (this.schemaLanguage != null) {
            result = 31 * result + this.schemaLanguage.hashCode();
        }
        result = 31 * result + this.factoryName.hashCode();
        return result;
    }

    public abstract Object createFactory();
}

