/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.util.collection;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.mule.runtime.api.util.collection.BiSmallMapDelegate;
import org.mule.runtime.api.util.collection.EmptySmallMapDelegate;
import org.mule.runtime.api.util.collection.SmallMapDelegate;
import org.mule.runtime.api.util.collection.SmallMapEntry;

class UniSmallMapDelegate<K, V>
extends SmallMapDelegate<K, V> {
    private Map.Entry<K, V> entry;

    public UniSmallMapDelegate(Map.Entry<K, V> entry, V previousValue) {
        this.entry = entry;
        this.previousValue = previousValue;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        return Objects.equals(this.entry.getKey(), key);
    }

    @Override
    public boolean containsValue(Object value) {
        return Objects.equals(this.entry.getValue(), value);
    }

    @Override
    public V get(Object key) {
        return Objects.equals(this.entry.getKey(), key) ? (V)this.entry.getValue() : null;
    }

    @Override
    SmallMapDelegate<K, V> fastPut(K key, V value) {
        if (this.containsKey(key)) {
            this.previousValue = this.entry.getValue();
            this.entry = new SmallMapEntry<K, V>(key, value);
            return this;
        }
        return new BiSmallMapDelegate<K, Object>(this.entry, new SmallMapEntry<K, V>(key, value), null);
    }

    @Override
    SmallMapDelegate<K, V> fastRemove(Object key) {
        if (this.containsKey(key)) {
            return new EmptySmallMapDelegate(this.entry.getValue());
        }
        return this;
    }

    @Override
    public Set<K> keySet() {
        return Collections.singleton(this.entry.getKey());
    }

    @Override
    public Collection<V> values() {
        return Collections.singletonList(this.entry.getValue());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return Collections.singleton(this.entry);
    }

    @Override
    SmallMapDelegate<K, V> copy() {
        return new UniSmallMapDelegate<K, Object>(this.entry, null);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UniSmallMapDelegate that = (UniSmallMapDelegate)o;
        return Objects.equals(this.entry, that.entry);
    }

    @Override
    public int hashCode() {
        return this.entry.hashCode();
    }
}

