/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.config;

import java.util.Optional;
import org.mule.runtime.api.config.Feature;

public enum MuleRuntimeFeature implements Feature
{
    HONOUR_RESERVED_PROPERTIES("Whether reserved properties such as 'app.name' can't be overridden by global properties.", "MULE-19038", "4.4.0, 4.3.1", "mule.honour.reserved.properties"),
    HANDLE_SPLITTER_EXCEPTION("If set to true, then DW will correctly handle Splitter's exceptions, avoiding some serialization issues.", "DW-383", "4.4.0, 4.3.1, 4.2.3", "mule.dw.handle_splitter_exception"),
    BATCH_FIXED_AGGREGATOR_TRANSACTION_RECORD_BUFFER("If set to true, then fixed batch aggregator will only commit when a full block is processed.", "EE-7443", "4.4.0, 4.3.1, 4.2.3", "mule.batch.fixed.aggregator.transaction.record.buffer"),
    COMPUTE_CONNECTION_ERRORS_IN_STATS("If set to true, the connection errors will be computed to trigger alerts.", "DW-383", "4.4.0, 4.3.1", "mule.compute.connection.errors.in.stats"),
    TO_STRING_TRANSFORMER_TRANSFORM_ITERATOR_ELEMENTS("If set to true, managed iterators transformed to Strings will show the representation of the elements instead of the generic 'org.mule.runtime.core.internal.streaming.object.ManagedCursorIteratorProvider$ManagedCursorIterator@######'.", "MULE-19323", "4.4.0", "mule.transformer.toString.transformIteratorElements"),
    ENABLE_POLICY_ISOLATION("If set to true, extensions imported by a policy will be managed in complete isolation from the extensions imported by the application that is being applied to, and validations will prevent the usage of explicit configurations declared by the application as part of the policy initialization.", "MULE-19226", "4.4.0, 4.3.1", "mule.enable.policy.isolation"),
    ENTITY_RESOLVER_FAIL_ON_FIRST_ERROR("If set to true, the Mule XML DSL parser will fail when deploying an application that declares a schema that cannot be located. If set to false, it will only fail if such application makes use of the namespace that such schema defines, instead of just declaring it.", "EE-7827", "4.4.0", "mule.entityResolver.failOnFirstError"),
    ENABLE_PROFILING_SERVICE("If set to true, profiling events will be produced", "MULE-19588", "4.5.0", "mule.enable.profiling.service"),
    SET_VARIABLE_WITH_NULL_VALUE("If set to true, the set variable will create a variable even if the value is null", "MULE-19443", "4.4.0", "mule.setVariable.WithNullValue"),
    START_EXTENSION_COMPONENTS_WITH_ARTIFACT_CLASSLOADER("When enabled, extensions will only be able to load exported resources from the deployable artifacts (application, policy, domain).", "MULE-19815", "4.4.0", "mule.startExtensionComponentsWithArtifactClassloader"),
    DW_REMOVE_SHADOWED_IMPLICIT_INPUTS("When enabled, DataWeave will remove implicit inputs when a variable with the same name is declared at the root level.", "DW-893", "4.4.0", "mule.dw.remove_shadowed_implicit_inputs"),
    DEFAULT_ERROR_HANDLER_NOT_ROLLBACK_IF_NOT_CORRESPONDING("When enabled, the default error handler added by the runtime will not rollback a transaction that should not be rollback by it", "MULE-19919", "4.5.0, 4.4.1", "mule.enable.default.errorhandler.not.rollback.incorrect.tx"),
    FORCE_RUNTIME_PROFILING_CONSUMERS_ENABLEMENT("When enabled, profiling consumers implemented by the runtime will be enabled by default.", "MULE-19967", "", "mule.force.runtime.profiling.consumers.enablement"),
    PARALLEL_FOREACH_FLATTEN_MESSAGE("When enabled, if the items to iterate over on a parallel-foreach scope are messages (such as the output of an operation that returns Result objects), they will be flattened in a way that is consistent with what the foreach scope does.", "MULE-20067", "4.5.0", "mule.parallelForeach.flattenMessage"),
    ENABLE_BYTE_BUDDY_OBJECT_CREATION("When enabled, the Objects factories will be created with Byte Buddy instead of CGLIB.", "W-10672687", "4.4.0", "mule.enable.byteBuddy.objectCreation"),
    MULE_PRINT_DETAILED_COMPOSITE_EXCEPTION_LOG("When enabled, AbstractForkJoinRouter based processors, such as ParallelForEach and ScatterGather routers, will show detailed error information for their failed routes.", "W-10965130", "4.5.0", "mule.detailedCompositeRoutingExceptionLog"),
    HONOUR_ERROR_MAPPINGS_WHEN_POLICY_APPLIED_ON_OPERATION("When enabled, the operation policy's error resolution is ignored so that the error mappings of the processor on which the policy was applied are set successfully", "W-11147961", "4.5.0", "mule.honourErrorMappingsWhenPolicyAppliedOnOperation"),
    SUPPRESS_ERRORS("When enabled, error suppression will happen. This will affect, for example, the Web Service Consumer connector and the Until Successful scope that will always report errors from their corresponding namespaces (MULE and WSC). Suppressed errors will be treated as underlying causes.", "W-11308645", "4.5.0, 4.4.0-202210, 4.3.0-202210", "mule.suppress.mule.exceptions"),
    RETHROW_EXCEPTIONS_IN_IDEMPOTENT_MESSAGE_VALIDATOR("When enabled, internal exceptions when processing an event in the 'idempotent-message-validator' will be rethrown instead of throwing a general MULE:DUPLICATE_MESSAGE.", "W-11529823", "4.5.0", "mule.rethrowExceptionsInIdempotentMessageValidator"),
    HONOUR_INSECURE_TLS_CONFIGURATION("When enabled, the insecure TLS configuration will be honoured even if there are fields of the TrustStore configured.", "W-10822938", "4.5.0", "mule.honour.insecure.tls.configuration"),
    USE_TRANSACTION_SINK_INDEX("When enabled, flux sinks will be cached using index as part of the key. If a sink is already in use, new sink will be created\nto avoid deadlock.", "W-12128703", "4.0.0, 4.1.0, 4.2.0, 4.3.0, 4.4.0, 4.5.0", "mule.transaction.sink.index"),
    SUPPORT_NATIVE_LIBRARY_DEPENDENCIES("When enabled, and the application needs to load a native library, the rest of the native libraries are preloaded in the application's Classloader.", "W-11855052", "4.6.0", "mule.support.native.library.dependencies"),
    CREATE_CHILD_POLICY_CONTEXT_FOR_PARALLEL_SCOPES("When enabled, a new (Source) Policy Context is created for the execution of parallel scopes: ParallelForeach, ScatterGather and Async", "W-13509911", "4.5.0", "mule.enable.policy.context.parallel.scopes"),
    DISABLE_SCHEDULER_LOGGING("When enabled, the Scheduler does not log exceptions.", "W-13881167", "4.6.0", "mule.disable.scheduler.logging"),
    ERROR_AND_ROLLBACK_TX_WHEN_TIMEOUT("When enabled, when a (local or xa) transaction reached timeout, an error will be thrown that can be handled using error handling", "W-14608096", "4.6.1", "mule.tx.error.when.timeout"),
    ENABLE_XML_SDK_MDC_RESET("When enabled, the MDC context will reset after XML SDK Operation has been executed.", "W-15206528", "4.8.0", "mule.enable.xml.sdk.mdc.reset"),
    HONOUR_PERSISTED_FLOW_STATE("When enabled, flows will honour the state configured in flows.deployment.properties when restarting the app, regardless of the initial state.", "W-15750334", "4.8.0", "mule.honour.persisted.flow.state"),
    FORK_JOIN_COMPLETE_CHILDREN_ON_TIMEOUT("When enabled, the processors that perform fork and join work (currently Scatter Gather and Parallel For Each), will take care of completing the child event contexts when there is a timeout.", "W-16941297", "4.10.0", "mule.forkJoin.completeChildContextsOnTimeout");

    private final String description;
    private final String issueId;
    private final String since;
    private final String overridingSystemPropertyName;

    private MuleRuntimeFeature(String description, String issue, String since) {
        this(description, issue, since, null);
    }

    private MuleRuntimeFeature(String description, String issueId, String since, String overridingSystemPropertyName) {
        this.description = description;
        this.issueId = issueId;
        this.since = since;
        this.overridingSystemPropertyName = overridingSystemPropertyName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getIssueId() {
        return this.issueId;
    }

    @Override
    public String getSince() {
        return this.since;
    }

    @Override
    public Optional<String> getOverridingSystemPropertyName() {
        return Optional.ofNullable(this.overridingSystemPropertyName);
    }
}

