/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.util;

import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class FunctionalUtils {
    public static <K, V> V computeIfAbsent(Map<K, V> map, K key, Function<K, V> mappingFunction) {
        V value = map.get(key);
        if (value == null) {
            value = mappingFunction.apply(key);
            map.put(key, value);
        }
        return value;
    }

    public static <T> Optional<T> or(Optional<T> optional, Supplier<Optional<T>> orElse) {
        return optional.isPresent() ? optional : orElse.get();
    }

    public static <T> void ifPresent(Optional<T> optional, Consumer<? super T> ifPresent, Runnable orElse) {
        if (optional.isPresent()) {
            ifPresent.accept(optional.get());
        } else {
            orElse.run();
        }
    }
}

