/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.metadata.descriptor;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.metadata.descriptor.BaseInputMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.InputMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.OutputMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.ParameterMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.TypeMetadataDescriptor;

public class ComponentMetadataTypesDescriptor {
    private final Map<String, MetadataType> inputMetadata;
    private final MetadataType outputMetadata;
    private final MetadataType outputAttributesMetadata;

    public ComponentMetadataTypesDescriptor(Map<String, MetadataType> inputMetadata, MetadataType outputMetadata, MetadataType outputAttributesMetadata) {
        this.inputMetadata = inputMetadata;
        this.outputMetadata = outputMetadata;
        this.outputAttributesMetadata = outputAttributesMetadata;
    }

    public Map<String, MetadataType> getInputMetadata() {
        return new HashMap<String, MetadataType>(this.inputMetadata);
    }

    public Optional<MetadataType> getInputMetadata(String parameterName) {
        return Optional.ofNullable(this.inputMetadata.getOrDefault(parameterName, null));
    }

    public Optional<MetadataType> getOutputMetadata() {
        return Optional.ofNullable(this.outputMetadata);
    }

    public Optional<MetadataType> getOutputAttributesMetadata() {
        return Optional.ofNullable(this.outputAttributesMetadata);
    }

    public static ComponentMetadataTypesDescriptorBuilder builder() {
        return new ComponentMetadataTypesDescriptorBuilder();
    }

    public static class ComponentMetadataTypesDescriptorBuilder {
        private BaseInputMetadataDescriptor inputMetadataDescriptor;
        private OutputMetadataDescriptor outputMetadataDescriptor;
        private boolean keepNonDynamicMetadata = false;

        private ComponentMetadataTypesDescriptorBuilder() {
        }

        public ComponentMetadataTypesDescriptorBuilder withInputMetadataDescriptor(InputMetadataDescriptor inputMetadataDescriptor) {
            return this.withInputMetadataDescriptor((BaseInputMetadataDescriptor)inputMetadataDescriptor);
        }

        public ComponentMetadataTypesDescriptorBuilder withInputMetadataDescriptor(BaseInputMetadataDescriptor inputMetadataDescriptor) {
            Objects.requireNonNull(inputMetadataDescriptor, "inputMetadataDescriptor must not be null");
            this.inputMetadataDescriptor = inputMetadataDescriptor;
            return this;
        }

        public ComponentMetadataTypesDescriptorBuilder withOutputMetadataDescriptor(OutputMetadataDescriptor outputMetadataDescriptor) {
            Objects.requireNonNull(outputMetadataDescriptor, "outputMetadataDescriptor must not be null");
            this.outputMetadataDescriptor = outputMetadataDescriptor;
            return this;
        }

        public ComponentMetadataTypesDescriptorBuilder keepNonDynamicMetadata(boolean keepNonDynamicMetadata) {
            this.keepNonDynamicMetadata = keepNonDynamicMetadata;
            return this;
        }

        public ComponentMetadataTypesDescriptor build() {
            if (this.inputMetadataDescriptor == null && this.outputMetadataDescriptor == null) {
                throw new IllegalArgumentException("Input or output metadata descriptor has to be defined");
            }
            Map<String, MetadataType> input = Collections.emptyMap();
            if (this.inputMetadataDescriptor != null) {
                input = this.inputMetadataDescriptor.getAllParameters().values().stream().filter(this.keepNonDynamicMetadata ? p -> true : ParameterMetadataDescriptor::isDynamic).collect(Collectors.toMap(ParameterMetadataDescriptor::getName, ParameterMetadataDescriptor::getType));
            }
            MetadataType output = null;
            MetadataType outputAttributes = null;
            if (this.outputMetadataDescriptor != null) {
                TypeMetadataDescriptor attributesMetadata;
                TypeMetadataDescriptor payloadMetadata = this.outputMetadataDescriptor.getPayloadMetadata();
                if (payloadMetadata.isDynamic() || this.keepNonDynamicMetadata) {
                    output = payloadMetadata.getType();
                }
                if ((attributesMetadata = this.outputMetadataDescriptor.getAttributesMetadata()).isDynamic() || this.keepNonDynamicMetadata) {
                    outputAttributes = attributesMetadata.getType();
                }
            }
            return new ComponentMetadataTypesDescriptor(input, output, outputAttributes);
        }
    }
}

