/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.internal.util.classloader;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class CallerClassUtils {
    private CallerClassUtils() {
    }

    public static ClassLoader getCallerClassClassLoader(String accessibleClassName) {
        StackWalker walker = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
        return (ClassLoader)walker.walk(s -> s.map(StackWalker.StackFrame::getDeclaringClass).map(Class::getClassLoader).filter(classLoader -> classLoader != null && classLoader != CallerClassUtils.class.getClassLoader()).filter(classLoader -> {
            try {
                classLoader.loadClass(accessibleClassName).getClassLoader();
                return true;
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }).findFirst()).orElseThrow(() -> new RuntimeException("Class loader not found"));
    }
}

