/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.el;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.security.Authentication;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.internal.event.ItemSequenceInfoBindingWrapper;

public class BindingContextUtils {
    public static final String MESSAGE = "message";
    public static final String PAYLOAD = "payload";
    public static final String DATA_TYPE = "dataType";
    public static final String ATTRIBUTES = "attributes";
    public static final String ERROR = "error";
    public static final String CORRELATION_ID = "correlationId";
    public static final String VARS = "vars";
    public static final String AUTHENTICATION = "authentication";
    public static final String FLOW = "flow";
    public static final String ITEM_SEQUENCE_INFO = "itemSequenceInfo";
    public static final BindingContext NULL_BINDING_CONTEXT = BindingContext.builder().build();

    private BindingContextUtils() {
    }

    public static BindingContext addEventBindings(Event event, BindingContext baseContext) {
        return BindingContextUtils.addEventBuindingsToBuilder(event, baseContext).build();
    }

    public static BindingContext.Builder addEventBuindingsToBuilder(Event event, BindingContext baseContext) {
        Objects.requireNonNull(event);
        Objects.requireNonNull(baseContext);
        BindingContext.Builder contextBuilder = BindingContext.builder(baseContext);
        contextBuilder.addBinding(VARS, new LazyValue<Supplier<TypedValue>>(() -> {
            Map<String, TypedValue<?>> flowVars = Collections.unmodifiableMap(event.getVariables());
            return new TypedValue(flowVars, DataType.builder().mapType(flowVars.getClass()).keyType(String.class).valueType(TypedValue.class).build());
        }));
        contextBuilder.addBinding(CORRELATION_ID, new LazyValue<Supplier<TypedValue>>(() -> new TypedValue<String>(event.getContext().getCorrelationId(), DataType.STRING)));
        contextBuilder.addBinding(ITEM_SEQUENCE_INFO, new LazyValue<Supplier<TypedValue>>(() -> new TypedValue<Object>(event.getItemSequenceInfo().map(ItemSequenceInfoBindingWrapper::new).orElse(null), DataType.fromType(ItemSequenceInfoBindingWrapper.class))));
        Message message = event.getMessage();
        contextBuilder.addBinding(MESSAGE, new LazyValue<Supplier<TypedValue>>(() -> new TypedValue<MessageWrapper>(new MessageWrapper(message), DataType.fromType(Message.class))));
        contextBuilder.addBinding(ATTRIBUTES, message.getAttributes());
        contextBuilder.addBinding(PAYLOAD, message.getPayload());
        contextBuilder.addBinding(DATA_TYPE, new LazyValue<Supplier<TypedValue>>(() -> new TypedValue<DataType>(message.getPayload().getDataType(), DataType.fromType(DataType.class))));
        contextBuilder.addBinding(ERROR, new LazyValue<Supplier<TypedValue>>(() -> {
            Error error = event.getError().isPresent() ? event.getError().get() : null;
            return new TypedValue<Error>(error, DataType.fromType(Error.class));
        }));
        contextBuilder.addBinding(AUTHENTICATION, new LazyValue<Supplier<TypedValue>>(() -> {
            Authentication authentication = event.getAuthentication().orElse(null);
            return new TypedValue<Authentication>(authentication, DataType.fromType(Authentication.class));
        }));
        return contextBuilder;
    }

    public static BindingContext getTargetBindingContext(Message message) {
        Objects.requireNonNull(message);
        return BindingContext.builder().addBinding(MESSAGE, new LazyValue<Supplier<TypedValue>>(() -> new TypedValue<MessageWrapper>(new MessageWrapper(message), DataType.fromType(Message.class)))).addBinding(PAYLOAD, message.getPayload()).addBinding(ATTRIBUTES, message.getAttributes()).build();
    }

    private static class MessageWrapper
    implements Message {
        private static final long serialVersionUID = -8097230480930728693L;
        private Message message;

        public MessageWrapper(Message message) {
            this.message = message;
        }

        @Override
        public <T> TypedValue<T> getPayload() {
            return this.message.getPayload();
        }

        @Override
        public <T> TypedValue<T> getAttributes() {
            return this.message.getAttributes();
        }

        public String toString() {
            return this.message.toString();
        }
    }
}

