/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.internal.meta.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.SubTypesModel;
import org.mule.runtime.api.meta.type.TypeCatalog;
import org.mule.runtime.api.util.Pair;

public final class DefaultTypeCatalog
implements TypeCatalog {
    private List<SubTypesMappingContainer> mappings = new LinkedList<SubTypesMappingContainer>();
    private Map<String, Map<String, ObjectType>> types = new LinkedHashMap<String, Map<String, ObjectType>>();
    private Map<String, String> extensionTypesInvertedIndex = new LinkedHashMap<String, String>();

    public DefaultTypeCatalog(Set<ExtensionModel> extensions) {
        extensions.forEach(e -> {
            this.mappings.add(new SubTypesMappingContainer(e.getSubTypes()));
            e.getTypes().forEach(t -> MetadataTypeUtils.getTypeId((MetadataType)t).ifPresent(id -> {
                if (this.types.containsKey(e.getName())) {
                    this.types.get(e.getName()).put((String)id, (ObjectType)t);
                } else {
                    LinkedHashMap<String, ObjectType> extensionTypesMap = new LinkedHashMap<String, ObjectType>();
                    extensionTypesMap.put((String)id, (ObjectType)t);
                    this.types.put(e.getName(), extensionTypesMap);
                }
                this.extensionTypesInvertedIndex.put((String)id, e.getName());
            }));
        });
    }

    @Override
    public Optional<ObjectType> getType(String typeId) {
        String extensionName = this.extensionTypesInvertedIndex.get(typeId);
        if (extensionName == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.types.get(extensionName).get(typeId));
    }

    @Override
    public Collection<ObjectType> getTypes() {
        ArrayList values = new ArrayList();
        for (Map<String, ObjectType> extensionTypeMap : this.types.values()) {
            extensionTypeMap.values().forEach(values::add);
        }
        return Collections.unmodifiableCollection(values);
    }

    @Override
    public Collection<ObjectType> getExtensionTypes(String extensionName) {
        if (this.types.containsKey(extensionName)) {
            return Collections.unmodifiableCollection(this.types.get(extensionName).values());
        }
        return Collections.emptyList();
    }

    @Override
    public Optional<String> getDeclaringExtension(String typeId) {
        return Optional.ofNullable(this.extensionTypesInvertedIndex.get(typeId));
    }

    @Override
    public Set<ObjectType> getSubTypes(ObjectType type) {
        return this.mappings.stream().map(m -> m.getSubTypes((MetadataType)type)).flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public Set<ObjectType> getSuperTypes(ObjectType type) {
        return this.mappings.stream().map(m -> m.getSuperTypes((MetadataType)type)).flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public Collection<ObjectType> getAllBaseTypes() {
        return this.mappings.stream().flatMap(c -> c.getAllBaseTypes().stream()).collect(Collectors.toCollection(LinkedList::new));
    }

    @Override
    public Collection<ObjectType> getAllSubTypes() {
        return this.mappings.stream().flatMap(c -> c.getAllSubTypes().stream()).collect(Collectors.toCollection(LinkedList::new));
    }

    @Override
    public boolean containsBaseType(ObjectType type) {
        return this.mappings.stream().anyMatch(c -> c.containsBaseType(type));
    }

    private static class SubTypesMappingContainer {
        private final Map<ObjectType, Set<ObjectType>> subTypesMapping;
        private final Map<String, Set<ObjectType>> subTypesById;

        SubTypesMappingContainer(Collection<SubTypesModel> subTypes) {
            this.subTypesMapping = this.toSubTypesMap(subTypes);
            this.subTypesById = this.subTypesMapping.entrySet().stream().map(entry -> new Pair(MetadataTypeUtils.getTypeId((MetadataType)((MetadataType)entry.getKey())).orElse(null), entry.getValue())).filter(p -> p.getFirst() != null).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond, (k, v) -> k, LinkedHashMap::new));
        }

        Collection<ObjectType> getSubTypes(MetadataType type) {
            Collection subTypes = MetadataTypeUtils.getTypeId((MetadataType)type).map(this.subTypesById::get).orElse(this.subTypesMapping.get(type));
            return subTypes != null ? Collections.unmodifiableCollection(subTypes) : Collections.emptyList();
        }

        List<ObjectType> getSuperTypes(MetadataType type) {
            LinkedList types = new LinkedList();
            this.subTypesMapping.entrySet().stream().filter(entry -> ((Set)entry.getValue()).contains(type)).forEach(entry -> {
                types.add(entry.getKey());
                types.addAll(this.getSuperTypes((MetadataType)entry.getKey()));
            });
            return Collections.unmodifiableList(types);
        }

        boolean containsBaseType(ObjectType type) {
            return MetadataTypeUtils.getTypeId((MetadataType)type).map(this.subTypesById::get).orElse(this.subTypesMapping.get(type)) != null;
        }

        List<ObjectType> getAllSubTypes() {
            return this.subTypesMapping.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        }

        Set<ObjectType> getAllBaseTypes() {
            return this.subTypesMapping.keySet();
        }

        private Map<ObjectType, Set<ObjectType>> toSubTypesMap(Collection<SubTypesModel> subTypes) {
            return subTypes.stream().collect(Collectors.toMap(SubTypesModel::getBaseType, SubTypesModel::getSubTypes));
        }
    }
}

