/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.deployment.meta;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.deployment.meta.AbstractMuleArtifactModel;
import org.mule.runtime.api.deployment.meta.AbstractMuleArtifactModelBuilder;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.util.Preconditions;

public abstract class MuleDeployableModel
extends AbstractMuleArtifactModel {
    private final List<String> configs;
    private final boolean redeploymentEnabled;

    protected MuleDeployableModel(String name, String minMuleVersion, MuleArtifactLoaderDescriptor classLoaderModelLoaderDescriptor, MuleArtifactLoaderDescriptor bundleDescriptorLoader, List<String> configs, Optional<Boolean> redeploymentEnabled) {
        super(name, minMuleVersion, classLoaderModelLoaderDescriptor, bundleDescriptorLoader);
        this.configs = configs == null ? new ArrayList() : configs;
        this.redeploymentEnabled = redeploymentEnabled.orElse(true);
    }

    public List<String> getConfigs() {
        return this.configs == null ? Collections.emptyList() : Collections.unmodifiableList(this.configs);
    }

    public boolean isRedeploymentEnabled() {
        return this.redeploymentEnabled;
    }

    protected static abstract class MuleDeployableModelBuilder<T extends AbstractMuleArtifactModelBuilder, M extends MuleDeployableModel>
    extends AbstractMuleArtifactModelBuilder<T, M> {
        private List<String> configs = new ArrayList<String>();
        private Boolean redeploymentEnabled;

        protected MuleDeployableModelBuilder() {
        }

        public void setConfigs(List<String> configs) {
            this.configs = configs;
        }

        @Override
        public final M build() {
            Preconditions.checkArgument(!StringUtils.isBlank((CharSequence)this.getName()), "name cannot be a blank");
            Preconditions.checkArgument(this.getMinMuleVersion() != null, "minMuleVersion cannot be null");
            Preconditions.checkArgument(this.getBundleDescriptorLoader() != null, "bundleDescriber cannot be null");
            return this.doCreateModel(this.configs, this.redeploymentEnabled);
        }

        protected abstract M doCreateModel(List<String> var1, Boolean var2);

        public void setRedeploymentEnabled(boolean redeploymentEnabled) {
            this.redeploymentEnabled = redeploymentEnabled;
        }
    }
}

