/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.value;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.exception.ExceptionUtils;

public final class ResolvingFailure {
    private final String message;
    private final String reason;
    private final String failureCode;

    private ResolvingFailure(String message, String reason, String failureCode) {
        this.message = message;
        this.reason = reason;
        this.failureCode = failureCode;
    }

    public String getMessage() {
        return this.message;
    }

    public String getFailureCode() {
        return this.failureCode;
    }

    public String getReason() {
        return this.reason;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.JSON_STYLE);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResolvingFailure that = (ResolvingFailure)o;
        return new EqualsBuilder().append((Object)this.message, (Object)that.message).append((Object)this.reason, (Object)that.reason).append((Object)this.failureCode, (Object)that.failureCode).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.message).append((Object)this.reason).append((Object)this.failureCode).toHashCode();
    }

    public static class Builder {
        private String message;
        private String reason;
        private String code;

        private Builder() {
        }

        public static Builder newFailure() {
            return new Builder();
        }

        public static Builder newFailure(Exception e) {
            Builder builder = new Builder();
            builder.message = e.getMessage();
            builder.reason = ExceptionUtils.getStackTrace((Throwable)e);
            return builder;
        }

        public ResolvingFailure build() {
            return new ResolvingFailure(this.message, this.reason, this.code);
        }

        public Builder withMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder withReason(String reason) {
            this.reason = reason;
            return this;
        }

        public Builder withFailureCode(String failureCode) {
            this.code = failureCode;
            return this;
        }
    }
}

