/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.internal.app.declaration.serialization.adapter;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Map;
import org.mule.runtime.api.app.declaration.CustomizableElementDeclaration;
import org.mule.runtime.api.app.declaration.IdentifiableElementDeclaration;
import org.mule.runtime.api.app.declaration.MetadataPropertiesAwareElementDeclaration;
import org.mule.runtime.api.app.declaration.ParameterElementDeclaration;
import org.mule.runtime.api.app.declaration.ParameterGroupElementDeclaration;
import org.mule.runtime.api.app.declaration.ParameterizedElementDeclaration;
import org.mule.runtime.api.app.declaration.fluent.EnrichableElementDeclarer;
import org.mule.runtime.api.app.declaration.fluent.ParameterSimpleValue;
import org.mule.runtime.api.app.declaration.fluent.ParameterizedElementDeclarer;

final class ElementDeclarationSerializationUtils {
    static final String FLOW = "FLOW";
    static final String SCOPE = "SCOPE";
    static final String ROUTE = "ROUTE";
    static final String SOURCE = "SOURCE";
    static final String ROUTER = "ROUTER";
    static final String CONFIG = "CONFIG";
    static final String OPERATION = "OPERATION";
    static final String CONNECTION = "CONNECTION";
    static final String GLOBAL_PARAMETER = "GLOBAL_PARAMETER";
    static final String NAME = "name";
    static final String KIND = "kind";
    static final String VALUE = "value";
    static final String FIELDS = "fields";
    static final String ROUTES = "routes";
    static final String TYPE_ID = "typeId";
    static final String REF_NAME = "refName";
    static final String CONFIG_REF = "configRef";
    static final String PARAMETER_GROUPS = "parameterGroups";
    static final String PARAMETERS = "parameters";
    static final String COMPONENTS = "components";
    static final String CONNECTION_FIELD = "connection";
    static final String PROPERTIES = "metadataProperties";
    static final String DECLARING_EXTENSION = "declaringExtension";
    static final String CUSTOM_PARAMETERS = "customConfigurationParameters";

    ElementDeclarationSerializationUtils() {
    }

    static void populateIdentifiableObject(JsonWriter out, IdentifiableElementDeclaration declaration, String kind) throws IOException {
        out.name(NAME).value(declaration.getName());
        out.name(DECLARING_EXTENSION).value(declaration.getDeclaringExtension());
        out.name(KIND).value(kind);
    }

    static void populateCustomizableObject(Gson delegate, JsonWriter out, CustomizableElementDeclaration declaration) throws IOException {
        out.name(CUSTOM_PARAMETERS).jsonValue(delegate.toJson(declaration.getCustomConfigurationParameters()));
    }

    static void populateMetadataAwareObject(Gson delegate, JsonWriter out, MetadataPropertiesAwareElementDeclaration declaration) throws IOException {
        out.name(PROPERTIES).jsonValue(delegate.toJson(declaration.getMetadataProperties()));
    }

    static JsonWriter populateParameterizedObject(Gson delegate, JsonWriter out, ParameterizedElementDeclaration declaration, String kind) throws IOException {
        ElementDeclarationSerializationUtils.populateIdentifiableObject(out, declaration, kind);
        ElementDeclarationSerializationUtils.populateCustomizableObject(delegate, out, declaration);
        ElementDeclarationSerializationUtils.populateMetadataAwareObject(delegate, out, declaration);
        out.name(PARAMETER_GROUPS).beginArray();
        for (ParameterGroupElementDeclaration group : declaration.getParameterGroups()) {
            out.jsonValue(delegate.toJson((Object)group));
        }
        out.endArray();
        return out;
    }

    static <T extends ParameterizedElementDeclarer> T declareParameterizedElement(Gson delegate, JsonObject jsonObject, ParameterizedElementDeclarer declarer) {
        ElementDeclarationSerializationUtils.declareEnrichableElement(delegate, jsonObject, declarer);
        JsonArray groups = jsonObject.get(PARAMETER_GROUPS).getAsJsonArray();
        groups.forEach(group -> ((ParameterizedElementDeclaration)declarer.getDeclaration()).addParameterGroup((ParameterGroupElementDeclaration)delegate.fromJson(group, ParameterGroupElementDeclaration.class)));
        return (T)declarer;
    }

    static <T extends EnrichableElementDeclarer> T declareEnrichableElement(Gson delegate, JsonObject jsonObject, EnrichableElementDeclarer declarer) {
        JsonArray customParameters = jsonObject.get(CUSTOM_PARAMETERS).getAsJsonArray();
        customParameters.forEach(p -> {
            ParameterElementDeclaration param = (ParameterElementDeclaration)delegate.fromJson(p, ParameterElementDeclaration.class);
            declarer.withCustomParameter(param.getName(), ((ParameterSimpleValue)param.getValue()).getValue());
        });
        Map properties = (Map)delegate.fromJson(jsonObject.get(PROPERTIES), new TypeToken<Map<String, String>>(){}.getType());
        properties.forEach(declarer::withProperty);
        return (T)declarer;
    }
}

