/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.util;

import javax.xml.namespace.QName;
import org.mule.runtime.api.meta.AnnotatedObject;

public class ComponentLocationProvider {
    protected static final QName NAME_ANNOTATION_KEY = new QName("http://www.mulesoft.org/schema/mule/documentation", "name");
    protected static final QName SOURCE_FILE_ANNOTATION_KEY = new QName("http://www.mulesoft.org/schema/mule/documentation", "sourceFileName");
    protected static final QName SOURCE_FILE_LINE_ANNOTATION_KEY = new QName("http://www.mulesoft.org/schema/mule/documentation", "sourceFileLine");

    public static String resolveProcessorRepresentation(String appId, String processorPath, Object element) {
        String docName = ComponentLocationProvider.getDocName(element);
        if (docName != null) {
            return String.format("%s @ %s:%s:%d (%s)", processorPath, appId, ComponentLocationProvider.getSourceFile((AnnotatedObject)element), ComponentLocationProvider.getSourceFileLine((AnnotatedObject)element), docName);
        }
        if (element instanceof AnnotatedObject) {
            return String.format("%s @ %s:%s:%d", processorPath, appId, ComponentLocationProvider.getSourceFile((AnnotatedObject)element), ComponentLocationProvider.getSourceFileLine((AnnotatedObject)element));
        }
        return String.format("%s @ %s", processorPath, appId);
    }

    public static String getDocName(Object element) {
        if (element instanceof AnnotatedObject) {
            Object docName = ((AnnotatedObject)element).getAnnotation(NAME_ANNOTATION_KEY);
            return docName != null ? docName.toString() : null;
        }
        return null;
    }

    protected static String getSourceFile(AnnotatedObject element) {
        return (String)element.getAnnotation(SOURCE_FILE_ANNOTATION_KEY);
    }

    protected static Integer getSourceFileLine(AnnotatedObject element) {
        return (Integer)element.getAnnotation(SOURCE_FILE_LINE_ANNOTATION_KEY);
    }
}

