/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.metadata.descriptor;

import org.mule.metadata.api.model.MetadataType;

public class TypeMetadataDescriptor {
    private final MetadataType type;
    private final boolean isDynamic;

    private TypeMetadataDescriptor(MetadataType type, boolean isDynamic) {
        this.type = type;
        this.isDynamic = isDynamic;
    }

    public static TypeMetadataDescriptorBuilder builder() {
        return new TypeMetadataDescriptorBuilder();
    }

    public MetadataType getType() {
        return this.type;
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }

    public static class TypeMetadataDescriptorBuilder {
        private MetadataType type;
        private boolean isDynamic = false;

        private TypeMetadataDescriptorBuilder() {
        }

        public TypeMetadataDescriptorBuilder withType(MetadataType type) {
            this.type = type;
            return this;
        }

        public TypeMetadataDescriptorBuilder dynamic(boolean isDynamic) {
            this.isDynamic = isDynamic;
            return this;
        }

        public TypeMetadataDescriptor build() {
            if (this.type == null) {
                throw new IllegalArgumentException("Type parameter cannot be null for ParameterMetadataDescriptor");
            }
            return new TypeMetadataDescriptor(this.type, this.isDynamic);
        }
    }
}

