/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.el;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.security.Authentication;

public class BindingContextUtils {
    public static final String MESSAGE = "message";
    public static final String PAYLOAD = "payload";
    public static final String DATA_TYPE = "dataType";
    public static final String ATTRIBUTES = "attributes";
    public static final String ERROR = "error";
    public static final String CORRELATION_ID = "correlationId";
    public static final String VARS = "vars";
    public static final String AUTHENTICATION = "authentication";
    public static final String FLOW = "flow";
    public static final BindingContext NULL_BINDING_CONTEXT = BindingContext.builder().build();

    private BindingContextUtils() {
    }

    public static BindingContext addEventBindings(Event event, BindingContext baseContext) {
        Objects.requireNonNull(event);
        Objects.requireNonNull(baseContext);
        BindingContext.Builder contextBuilder = BindingContext.builder(baseContext);
        Map<String, TypedValue<?>> flowVars = Collections.unmodifiableMap(event.getVariables());
        contextBuilder.addBinding(VARS, new TypedValue(flowVars, DataType.builder().mapType(flowVars.getClass()).keyType(String.class).valueType(TypedValue.class).build()));
        contextBuilder.addBinding(CORRELATION_ID, new TypedValue<String>(event.getContext().getCorrelationId(), DataType.STRING));
        Message message = event.getMessage();
        contextBuilder.addBinding(MESSAGE, new TypedValue<Message>(message, DataType.fromType(Message.class)));
        contextBuilder.addBinding(ATTRIBUTES, message.getAttributes());
        contextBuilder.addBinding(PAYLOAD, message.getPayload());
        contextBuilder.addBinding(DATA_TYPE, new TypedValue<DataType>(message.getPayload().getDataType(), DataType.fromType(DataType.class)));
        Error error = event.getError().isPresent() ? event.getError().get() : null;
        contextBuilder.addBinding(ERROR, new TypedValue<Error>(error, DataType.fromType(Error.class)));
        Authentication authentication = event.getAuthentication().orElse(null);
        contextBuilder.addBinding(AUTHENTICATION, new TypedValue<Authentication>(authentication, DataType.fromType(Authentication.class)));
        return contextBuilder.build();
    }

    public static BindingContext getTargetBindingContext(Message message) {
        Objects.requireNonNull(message);
        return BindingContext.builder().addBinding(MESSAGE, new TypedValue<Message>(message, DataType.fromType(Message.class))).addBinding(PAYLOAD, message.getPayload()).addBinding(ATTRIBUTES, message.getAttributes()).build();
    }
}

